/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)gmt_math_win32.h	1.10  06/17/99
 *
 *	Copyright (c) 1991-1999 by P. Wessel and W. H. F. Smith
 *	See COPYING file for copying and redistribution conditions.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	NOVit under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; version 2 of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	Contact info: www.soest.hawaii.edu/gmt
 *--------------------------------------------------------------------*/
/*
 * This include file contains definitions of functions that are not part
 * of POSIX but are often distributed anyway on most systems.
 * The purpose is to take advantage of built-in functions
 * if they exist and provide an alternative definition otherwise.
 *
 *	This file is made for Win32 systems based on functions
 *	distributed with Microsoft Visual C/C++ tools.  Other Win32
 *	C environments may differ - check your documentation.
 *
 * Author:	Paul Wessel
 * Date:	05-NOV-1998
 *		13-JAN-1999 PW: Added Bessel functions
 *		05-FEB-1999 PW: Added modified Bessel etc.
 *
 */

#define copysign(x,y) _copysign(x,y)
#define log1p(x) log (1.0+(x))
#define hypot(x,y) _hypot(x,y)
#define acosh(x) d_log((x) + (d_sqrt(((x)*(x)) - 1)))
#define asinh(x) d_log((x) + (d_sqrt(((x)*(x)) + 1)))
#define atanh(x) (fabs(x) < 1.0 ? (0.5*d_log((1+(x))/(1-(x)))) : \
	(0.5*d_log(((x)+1)/((x)-1))))
#define rint(x) (floor((x)+0.5))
#define irint(x) ((int)rint(x))
#define ISNAND_EXISTS 1
#define GMT_is_dnan(x) _isnan(x)
#define ISNANF_EXISTS 1
#define GMT_is_fnan(x) _isnan((double)(x))
extern int _isnan(double x);
#define j0(x) _j0(x)
#define j1(x) _j1(x)
#define jn(n,x) _jn(n,x)
#define y0(x) _y0(x)
#define y1(x) _y1(x)
#define yn(n,x) _yn(n,x)

/* These functions used by grdmath and gmtmath are declared in gmt_stat.c */

EXTERN_MSC double GMT_bei(double x);
EXTERN_MSC double GMT_ber(double x);
EXTERN_MSC double GMT_kei(double x);
EXTERN_MSC double GMT_ker(double x);
EXTERN_MSC double GMT_plm(int l, int m, double x);
EXTERN_MSC double GMT_factorial(int n);
EXTERN_MSC double GMT_i0(double x);
EXTERN_MSC double GMT_i1(double x);
EXTERN_MSC double GMT_in(int n, double x);
EXTERN_MSC double GMT_k0(double x);
EXTERN_MSC double GMT_k1(double x);
EXTERN_MSC double GMT_kn(int n, double x);
EXTERN_MSC double GMT_dilog(double x);

#define NEED_GMT_ERF 1
#define erf(x) GMT_erf(x)
EXTERN_MSC double GMT_erf(double x);
#define NEED_GMT_ERFC 1
#define erfc(x) GMT_erfc(x)
EXTERN_MSC double GMT_erfc(double x);
