/*--------------------------------------------------------------------
 *    The GMT-system:	gmt_math.h	[automatically generated]
 *
 *	Copyright (c) 1991-1999 by P. Wessel and W. H. F. Smith
 *	See COPYING file for copying and redistribution conditions.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; version 2 of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	Contact info: www.soest.hawaii.edu/gmt
 *--------------------------------------------------------------------*/
/*
 * This include file contains definitions of functions that are not part
 * of POSIX but are often distributed anyway on most systems.  This file
 * is automatically generated by the GMT makefile and determines if the
 * required functions are present or not and sets the macro-definitions
 * accordingly.  The purpose is to take advantage of the built-in functions
 * if they exist and provide an alternative definition otherwise.
 *
 * This include file was generated by gmt_math_init.csh on:
 *
 *
 *	Date:   Thu Jun 17 06:48:35 1999
 *	System: OS/2 paladin 2 2.40 i386
 *
 */

/**********************************************************************
      Note: The OS/2 version of gmt_math.h uses Sun Microsystem's
      "Freely-Distrubuted Math Library" to provide the math functions
      needed by GMT. fdlibm, as it is known, is available from NETLIB,
      http://www.netlib.org. All the GMT-required math functions are
      to be fouind in fdlibm except for irint, which is defined in the
      macro below.
***********************************************************************/
#define irint(x) ((int)rint(x))

/* Misc. ANSI-C math functions used by grdmath and gmtmath */
/* Note: these are all provided, save for irint, by fdlibm */

/* Systems with the sincos function can get some speed gains */

#ifdef SINCOS
extern void sincos (double x, double *s, double *c);
#endif

/* These functions used by grdmath and gmtmath are declared in gmt_stat.c */

extern double GMT_bei(double x);
extern double GMT_ber(double x);
extern double GMT_kei(double x);
extern double GMT_ker(double x);
extern double GMT_plm(int l, int m, double x);
extern double GMT_factorial(int n);
extern double GMT_i0(double x);
extern double GMT_i1(double x);
extern double GMT_in(int n, double x);
extern double GMT_k0(double x);
extern double GMT_k1(double x);
extern double GMT_kn(int n, double x);
extern double GMT_dilog(double x);

