/*
 * 	@(#)gmt_endian.c	1.4  06/17/99
 *
 * gmt_endian reads a 2-byte integer from GMT_short.b.  The
 * integer was initialized to 1 and written on a Sun.
 * If the read value is not 1 then the byte order on this
 * machine is opposite than that the machine that wrote it
 * and we must apply swapping on code that reads binary data.
 *
 * Author:	Paul Wessel
 * Date:	30-APR-1999
 */
 
#define _POSIX_SOURCE 1

#include <stdio.h>
#include <stdlib.h>

main ()
{
	short int one;
	FILE *fp;

	if ((fp = fopen ("GMT_short.b", "rb")) == NULL) {
		fprintf (stderr, "gmt_endian: Cannot open GMT_short.b\n");
		exit (EXIT_FAILURE);
	}

	/* Read the value of interest */

        if ((fread ((void *)&one, sizeof (short int), (size_t)1, fp)) != 1) {
		fprintf (stderr, "gmt_endian: Cannot read from GMT_short.b\n");
		exit (EXIT_FAILURE);
	}

	/* Close and exit */
	
        fclose (fp);

	if (one == 1) putchar ('#');

	printf ("GMTSWAP\t= -DGMTSWAP\t# Set to compile in byte-swapping of native binary data\n");

	exit (EXIT_SUCCESS);
}
