.TH GRDRASTER l "1 July 1999"
.SH NAME
grdraster \- extract subregion from a binary raster and write a grd file
.SH SYNOPSIS
\fBgrdraster\fP [ \fIfilenumber\fP ] \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP]
\fB\-G\fP\fIgrdfilename\fP [ \fB\-I\fP\fIx_inc\fP[\fBm|c\fP][/\fIy_inc\fP[\fBm|c\fP]] ]
[ \fB\-J\fP\fIparams\fP ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdraster\fP reads a file called \fIgrdraster.info\fP from the directory
pointed to by the environment parameter $GMT_GRIDDIR (if this parameter is
not set it defaults to $GMTHOME/lib/dbase).  The info file defines binary
arrays of data stored in scan-line format in data files.  Each file is given
a \fIfilenumber\fP in the info file.  \fBgrdraster\fP figures out how to
load the raster data into a grd file spanning a region defined by \fB\-R\fP.
By default the grid spacing equals the raster spacing.  The \fB\-I\fP option
may be used to sub-sample the raster data.  No filtering or interpolating is
done, however; the \fIx_inc\fP and \fIy_inc\fP of the grd file must be
multiples of the increments of the raster file and \fBgrdraster\fP simply
takes every n'th point.  The output of \fBgrdraster\fP is either grid or
pixel registered depending on the registration of the raster used.  It is up
to the GMT system person to maintain the \fBgrdraster\fP.info file in
accordance with the available rasters at each site.  Raster data sets are
not supplied with GMT but can be obtained by anonymous ftp and on
cd-rom (see README page in dbase directory).  \fBgrdraster\fP will list the
available files if no arguments are given.
.TP
\fIfilenumber\fP
An integer matching one of the files listed in the grdraster.info file.
.sp
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
If \fBr\fP is appended, you must also specify a map projection to define the shape of
your region.
.SH OPTIONS
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to indicate minutes or \fBc\fP to indicate seconds.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx, or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
.sp
To extract data from raster 1, taking one point every 30 minutes, in an
area extended beyond 360 degrees to allow later filtering, try
.br
.sp
\fBgrdraster\fP 1 \fB\-R\fP-4/364/-62/62 \fB\-I\fP30\fBm \-G\fPdata.grd
.br
.sp
To obtain data for an oblique Mercator projection we need to extract more data
that is actually used.  This is necessary because the output of \fBgrdraster\fP has edges defined by
parallels and meridians, while the oblique map in general does not.  Hence, to
get all the data from data set 3 needed to make a contour map for the region defined by its
lower left and upper right corners and the desired projection, try
.br
.sp
\fBgrdraster\fP 3 \fB\-R\fP160/20/220/30\fBr\fP \fB\-Joc\fP190/25.5/292/69/1 \fB\-G\fPdata.grd
.SH SEE ALSO
gmtdefaults, gmt, grdsample, grdfilter
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1999, The Generic Mapping Tools (GMT) version
3.2 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
