#!/bin/bash
#
#	@(#)cygwin_gmt_prep.bash	1.3  01/15/99
#
#	Purpose: Create the necessary links and files for GMT to install
#		 without a hitch under CYGWIN32. Beta 20.1
#		 Also prepares makegmt.macros from makegmt.macros.orig
#
#	Author:	Paul Wessel
#	Date:	10-JAN-1999
#

# Edit these to reflect your environment

cygwin='//D/cygnus/cygwin-b20/H-i586-cygwin32/i586-cygwin32'
netcdf='//D/netcdf-3.4'

#---------EDIT NO MORE----------

echo -n "==> Do you prefer inches or centimeters as default unit? (i/c) [i]: "
read answer
if [ $answer = "c" ] || [ $answer = "C" ]; then
	SI="SI"
else
	SI="#SI"
fi

echo "cygwin_gmt_prep: Make /tmp, /usr, /usr/lib, /usr/include, /usr/local, /usr/local/netcdf"

if [ ! -e /tmp ]; then
	mkdir /tmp
fi
if [ ! -e /usr ]; then
	mkdir /usr
fi
if [ ! -e /usr/local ]; then
	mkdir /usr/local
fi
if [ ! -e /usr/lib ]; then
	ln -s $cygwin/lib /usr/lib
fi
if [ ! -e /usr/include ]; then
	ln -s $cygwin/include /usr/include
fi
if [ ! -e /usr/local/netcdf ]; then
	ln -s $netcdf /usr/local/netcdf
fi

echo "Make makegmt.macros"

sed -e /Compiler/q makegmt.macros.orig -e s/csh/bash/g > makegmt.macros
cat << EOF >> makegmt.macros
#-------------------------------------------------------------------------------
CC_OPT	= -O -ansi -D_WIN32
#-------------------------------------------------------------------------------
EOF
sed -n '/Misc./,$p' makegmt.macros.orig | sed -e 's/#DOS/DOS/g' -e "s/#SI/$SI/g" >> makegmt.macros

echo "cygwin_gmt_prep: Done"
