/*
 *	@(#)cpsdecode.c	1.2  02/19/99
 *
 *  cpsdecode - Decoding Complete PostScript (cps) files that
 *		contain all the commands and the data required
 *		to recreate a plot.
 *
 * Author:	Paul Wessel, SOEST, U. of Hawaii
 * Version:	1.1
 * Date:	19-FEB-1999
 *
 * cpsdecode will extract a plot script and any required data
 * files (including other scripts) from the PostScript file comments.
 *
 * e.g.,
 *	cpsdecode Figure_3.ps
 */

#include "cps.h"

main (int argc, char **argv)
{
	int i, k, n_files;
	int verbose = FALSE, first, error = FALSE, expand = TRUE, decode = TRUE;
	char buffer[BUFSIZ], cmd[BUFSIZ], file[BUFSIZ], *s;
	FILE *fp = stdin, *process;

	for (i = 1; i < argc; i++) {

		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
				case '\0':
					fp = stdin;
					break;
				case 'e':
				case 'E':
					decode = FALSE;
					break;
				case 'u':
				case 'U':
					expand = FALSE;
					break;
				case 'v':
				case 'V':
					verbose = TRUE;
					break;
				default:
					error = TRUE;
					break;
			}
		}
		else {
			k = i;
			if ((fp = fopen (argv[k], "r")) == NULL) {
				fprintf (stderr, "cpsdecode: Could not open file %s\n", argv[k]);
				exit (EXIT_FAILURE);
			}
		}
	}

	if (expand && !decode) {
		fprintf (stderr, "cpsdecode: ERROR.  Cannot decompress without first decoding\n");
		error = TRUE;
	}
	if (argc < 2 || error) {
		fprintf (stderr, "usage: cpsdecode [PostScriptfile] [-e] [-u] [-v]\n\n");
		fprintf (stderr, "	 Give name of PostScript-file read from stdin\n\n");
		fprintf (stderr, "	 OPTIONS\n");
		fprintf (stderr, "	 -e do NOT decode content. Requires -u [Default will]\n");
		fprintf (stderr, "	 -u do NOT uncompress [Default will]\n");
		fprintf (stderr, "	 -v will report on progress [Default is silent]\n");
		exit (EXIT_FAILURE);
	}

	if (verbose && fp == stdin)
		fprintf (stderr, "cpsdecode: Reading standard input\n");
	else if (verbose)
		fprintf (stderr, "cpsdecode: Reading %s\n", argv[k]);
	if (verbose) fprintf (stderr, "cpsdecode: decompression turned off\n");

	fgets (buffer, BUFSIZ, fp);
	if (strncmp (buffer, "%!PS", 4)) {
		fprintf (stderr, "cpsdecode: %s is not a PostScript file\n", argv[1]);
		exit (EXIT_FAILURE);
	}

	n_files = 0;
	first = TRUE;

	/* Skip to first occurrence of %%CPS-F: */

	while ((s = fgets (buffer, BUFSIZ, fp)) && strncmp (buffer, "%%CPS-F: ", CPS_FLAG_WIDTH));

	while (s) {	/* There is more to decode */

		buffer[strlen (buffer)-1] = '\0';	/* Chop off newline */

		strcpy (file, &buffer[CPS_FLAG_WIDTH]);	/* Name of this file */

		if (first && decode) {	/* First file is plain ASCII master shell script */

			if (verbose) fprintf (stderr, "cpsdecode: Write master script %s\n", file);

			if ((process = fopen (file, "w")) == NULL) {
				fprintf (stderr, "cpsdecode: Trouble creating file %s\n", file);
				exit (EXIT_FAILURE);
			}
		}
		else {	/* Later files are encoded and must be unscrambled */

			if (verbose) fprintf (stderr, "cpsdecode: Process %s [%s]", file, DECODE);

			if ((process = popen (DECODE, "w")) == NULL) {
				fprintf (stderr, "cpsdecode: Trouble opening process %s\n", DECODE);
				exit (EXIT_FAILURE);
			}
		}

		/* Read and feed to process or file */

		while ((s = fgets (buffer, BUFSIZ, fp)) && !strncmp (buffer, "%%CPS|", CPS_INDENT)) fprintf (process, "%s", &buffer[CPS_INDENT]);
		fclose (process);

		if (!first && expand) {	/* Uncompress the file */

			if (verbose) fprintf (stderr, "+[%s]\n", EXPAND);
			sprintf (cmd, "%s %s.%s\0", EXPAND, file, SUFFIX);
			system (cmd);
		}

		first = FALSE;
		n_files++;
	}

	if (fp != stdin) fclose (fp);

	if (n_files == 0)
		fprintf (stderr, "cpsdecode: No files extracted. %s is probably not a CPS file\n", argv[1]);
	else if (verbose)
		fprintf (stderr, "cpsdecode: Extracted %d files from %s\n", n_files, argv[1]);

	exit (EXIT_SUCCESS);
}
