.TH CPS l l "1 July 1999"
.SH NAME
cpsencode \- Embed shell scripts and data files in Complete \fIPostScript\fP (CPS) file
.SH SYNOPSIS
\fBcpsencode\fP shell-script [ \fB\-e\fP ] [ \fB\-u\fP ] [ \fB\-v\fP ] >> \fIPostScript\fP-file
.SH NAME
cpsdecode \- Extract shell scripts and data files from Complete \fIPostScript\fP (CPS) file
.SH SYNOPSIS
\fBcpsdecode\fP [ \fIPostScript\fP-file ] [ \fB\-e\fP ] [ \fB\-u\fP ] [ \fB\-v\fP ]
.SH DESCRIPTION
\fBcpsencode\fP takes a shell-script file as argument and will write
its contents as well as the contents of any data files referred to
in the script to standard output, which you append to the \fIPostScript\fP
file.  These lines are started
with the \fIPostScript\fP comment %%CPS which is used by \fBcpsdecode\fP
to unscramble the script and data files at a later time.  The latter
reads the \fIPostScript\fP file from stdin if no file is given.
.OPTIONS
.TP
.B \-e
Leave unencoded.  Files are not decoded from ASCII to binary or
encoded from binary to ASCII.  Requires \fB\-u\fP and that all
data files are ASCII.
.TP
.B \-u
Leave uncompressed.  Files are not compressed prior to the encode stage
or decompressed after the encode stage.
.TP
.B \-v
Verbose.  Report the progress of encoding/decoding the script and any data files
referred to in the script [Default is silent].
.SH SPECIAL
A special mechanism is available if you want to embed files that are
not directly used by the script.  These could be hidden files that
some commands will read implicitly (say, a .cshrc file) or related
documentation files that cannot be executed in the script.  You can
import such files by adding the script comment
.br
.sp
 #CPS: \fIfilename\fP
.br
.sp
You will need one such line for each file you require.  Any file is only
written once so repeated references to the same file by the script or
this special mechanism will only result in one import.
.SH EXAMPLES
Let us say you have a cshell script called Figure_8.csh which creates
the \fIPostScript\fP file Figure_8.ps.  Figure_8.csh operates on several
data files in order to make the plot.  You turn this plot file into a
Complete \fIPostScript\fP (CPS) file with the command
.br
.sp
\fBcpsencode \-v\fP Figure_8.csh >> Figure_8.ps
.br
.sp
Alternatively, let that be the last command in the script so that it
is automatically done by the script itself.
.br
To unscramble the CPS file, simply say
.br
.sp
\fBcpsdecode \-v\fP Figure_8.ps
.SH BUGS
\fBcpsencode\fP assumes good script etiquette so that any temporary files
created by your script are removed before \fBcpsencode\fP is called.
Otherwise they will take up unneccesary space in the Complete \fIPostScript\fP
(CPS) file.  \fBcpsencode\fP will have trouble if you script changes
directories with the \fIcd\fP command since filenames become relative to
another directory.  Using absolute paths name for files (starting with /,
~/. or ~user/) is bad practice since other users may not be able to
access those files.
.SH AUTHOR
Paul Wessel, Geology & Geophysics, SOEST, University of Hawaii,
1680 East-West Road, Honolulu HI 96822, USA.  www.soest.hawaii.edu/wessel.
