/*	@(#)cps.h	1.7  06/22/99
 *
 *	Include file for CPS package
 *
 * Author:	Paul Wessel, SOEST, U. of Hawaii
 * Version:	1.1
 * Date:	19-FEB-1999
 */

#define _POSIX_SOURCE 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
#define DIR_DELIM '\\'
/* Various items normally in unistd.h */
#define R_OK 04
#define access(path, mode) _access(path, mode)
extern int _access (const char *path, int mode);
#define popen(cmd, type) _popen(cmd, type)
extern FILE *_popen (const char *cmd, const char *type);
#define pclose(fp) _pclose(fp)
extern int _pclose (FILE *fp);
#else
#define DIR_DELIM '/'
#include <unistd.h>
#endif

/* Declare two non-POSIX functions */

FILE *popen (const char *cmd, const char *type);
int pclose (FILE *stream);

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define CPS_FLAG_WIDTH 9
#define CPS_INDENT 6

/* CAT takes a file name and prints contents to stdout, e.g.
 * CAT test.c
 * You may replace this with similar programs on non-UNIX systems */

#define CAT		"cat"

/* If you for some reason do not or cannot use bzip2
 * you can replace it with gzip, zip, or compress.
 * You must then also replace the SUFFIX accordingly.
 */

#define COMPRESS	"bzip2 -cf9"
#define EXPAND		"bzip2 -d"
#define SUFFIX		"bz2"

/* If you want to use another mechanism for en/de-coding
 * you must replace these with perhaps binhex/hexbin
 * or others.  You must know what you are doing and
 * check the cpsencode/decode source to see if it is ok.
 * It may be you need to pass more options.
 */

#define ENCODE		"uuencode"
#define DECODE		"uudecode"
