.TH TREND2D l "1 July 1999"
.SH NAME
trend2d \- Fit a [weighted] [robust] polynomial model for z = f(x,y) to xyz[w] data.
.SH SYNOPSIS
\fBtrend2d\fP \fB\-F\fP\fI<xyzmrw>\fP \fB\-N\fP\fIn_model\fP[\fBr\fP] [ \fIxyz[w]file\fP ]
[ \fB\-C\fP\fIcondition_#\fP ] [ \fB\-H\fP[\fInrec\fP] ][ \fB\-I\fP[\fIconfidence_level\fP] ] [ \fB\-V\fP ] [ \fB\-W\fP ]
[ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-bo\fP[\fBs\fP] ]
.SH DESCRIPTION
\fBtrend2d\fP reads x,y,z [and w] values from the first three [four] columns on standard input
[or \fIxyz[w]file\fP] and fits a regression model z = f(x,y) + e by [weighted] least squares.  The
fit may be made robust by iterative reweighting of the data.  The user may also search for the number
of terms in f(x,y) which significantly reduce the variance in z.  n_model may be in [1,10] to fit
a model of the following form (similar to grdtrend):
.sp
m1 + m2*x + m3*y + m4*x*y + m5*x*x + m6*y*y + m7*x*x*x + m8*x*x*y + m9*x*y*y + m10*y*y*y.
.sp
The user must specify \fB\-N\fP\fIn_model\fP, the number of model parameters to use;
thus, \fB\-N\fP\fI4\fP fits a bilinear trend, \fB\-N\fP\fI6\fP a quadratic surface,
and so on.  Optionally, append \fBr\fP to perform a robust fit.  In
this case, the program will iteratively reweight the data based on a robust scale estimate,
in order to converge to a solution insensitive to outliers.  This may be handy when separating
a "regional" field from a "residual" which should have non-zero mean, such as a local mountain
on a regional surface.
.TP
.B \-F
Specify up to six letters from the set {x y z m r w} in any order to create columns of
ASCII [or binary] output.  x = x, y = y, z = z, m = model f(x,y), r = residual z - m, w = weight used in fitting.
.TP
.B \-N
Specify the number of terms in the model, \fIn_model\fP, and append \fBr\fP
to do a robust fit.  E.g., a robust bilinear model is \fB\-N\fP\fI4\fP\fBr\fP.
.SH OPTIONS
.TP
\fIxyz[w]file\fP
ASCII [or binary, see \fB\-b\fP] file containing x,y,z [w] values in the first 3 [4] columns.  If no file is specified, \fBtrend2d\fP
will read from standard input.
.TP
.B \-C
Set the maximum allowed condition number for the matrix solution.  \fBtrend2d\fP
fits a damped least squares model, retaining only that part of the eigenvalue spectrum such that
the ratio of the largest eigenvalue to the smallest eigenvalue is \fIcondition_#\fP.
[Default:  \fIcondition_#\fP = 1.0e06. ].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
Iteratively increase the number of model parameters, starting at one, until
\fIn_model\fP is reached or the reduction in variance of the model is not significant at the
\fIconfidence_level\fP level.  You may set \fB\-I\fP only, without an attached number; in this
case the fit will be iterative with a default confidence level of 0.51.  Or choose your own level
between 0 and 1.  See remarks section.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Weights are supplied in input column 4.  Do a weighted least squares fit [or start with these weights
when doing the iterative robust fit].  [Default reads only the first 3 columns.]
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 3 (or 4 if \fB\-W\fP is set) input columns].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is double].
.SH REMARKS
The domain of x and y will be shifted and scaled to [-1, 1] and the basis functions are built from
Chebyshev polynomials.  These have a numerical advantage in the form of the matrix which must be
inverted and allow more accurate solutions.  In many applications of \fBtrend2d\fP the user has data located
approximately along a line in the x,y plane which makes an angle with the x axis (such as data collected
along a road or ship track).  In this case the accuracy could be improved by a rotation of the x,y axes.
\fBtrend2d\fP does not search for such a rotation; instead, it may find that the matrix problem has deficient
rank.  However, the solution is computed using the generalized inverse and should still work out OK.
The user should check the results graphically if \fBtrend2d\fP shows deficient rank.  NOTE: The model
parameters listed with \fB\-V\fP are Chebyshev coefficients; they are not numerically equivalent to the m#s
in the equation described above.  The description above is to allow the user to match \fB\-N\fP with the
order of the polynomial surface.
.sp
The \fB\-N\fP\fIn_model\fP\fBr\fP (robust) and \fB\-I\fP (iterative) options evaluate the significance of the improvement
in model misfit Chi-Squared by an F test.  The default confidence limit is set at 0.51; it can be changed
with the \fB\-I\fP option.  The user may be surprised to find that in most cases the reduction in variance
achieved by increasing the number of terms in a model is not significant at a very high degree of
confidence.  For example, with 120 degrees of freedom, Chi-Squared must decrease by 26% or more to be significant
at the 95% confidence level.  If you want to keep iterating as long as Chi-Squared is decreasing, set
\fIconfidence_level\fP to zero.
.sp
A low confidence limit (such as the default value of 0.51) is needed to make the robust method
work.  This method iteratively reweights the data to reduce the influence of outliers.  The
weight is based on the Median Absolute Deviation and a formula from Huber [1964], and is 95%
efficient when the model residuals have an outlier-free normal distribution.  This means that the
influence of outliers is reduced only slightly at each iteration; consequently the reduction in
Chi-Squared is not very significant.  If the procedure needs a few iterations to successfully
attenuate their effect, the significance level of the F test must be kept low.
.SH EXAMPLES
To remove a planar trend from data.xyz by ordinary least squares, try:
.sp
\fBtrend2d\fP data.xyz \fB\-F\fPxyr \fB\-N\fP2 > detrended_data.xyz
.sp
To make the above planar trend robust with respect to outliers, try:
.sp
\fBtrend2d\fP data.xzy \fB\-F\fPxyr \fB\-N\fP2\fBr\fP > detrended_data.xyz
.sp
To find out how many terms (up to 10) in a robust interpolant are significant in fitting data.xyz, try:
.sp
\fBtrend2d\fP data.xyz \fB\-N\fP10\fBr \-I\fP \fB\-V\fP
.SH SEE ALSO
gmt, grdtrend, trend1d
.SH REFERENCES
Huber, P. J., 1964, Robust estimation of a location parameter, \fIAnn. Math. Stat., 35,\fP 73-101.
.br
.sp
Menke, W., 1989, Geophysical Data Analysis:  Discrete Inverse Theory, Revised Edition, Academic Press, San Diego.
