.TH PSXYZ l "1 July 1999"
.SH NAME
psxyz \- Plot lines, polygons, and symbols in 3-D
.SH SYNOPSIS
\fBpsxyz\fB \fIfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fIwest/east/south/north/zmin/zmax\fP[\fBr\fP]
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-C\fP\fIcptfile\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ]
[ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-K\fP ] [ \fB\-L\fP ] [ \fB\-M\fP[\fIflag\fP] ]
[ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-S\fP[\fIsymbol\fP][\fIsize\fP] ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ]
[ \fB\-V\fP ] [ \fB\-W\fP[\fIpen\fP] ]
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fIzlevel\fP ] [ \fB\-:\fP ] [ \fB\-c\fP\fIcopies\fP ]
[ \fB\-bi\fP[\fBs\fP][\fIn\fP] ]
.SH DESCRIPTION
\fBpsxyz\fP reads (x,y,z) triplets from \fIfiles\fP [or standard input] and
generates \fIPostScript\fP code that will plot lines, polygons, or symbols at those locations in 3-D.
If a symbol is selected and no symbol size given, then psxyz will interpret the fourth column of the
input data as symbol size in inch.  If no symbols are specified then the symbol code (see \fB\-S\fP below)
must be present as last column in the input.  Multiple segment files may be plotted using the \fB\-M\fP option.
If no symbols are selected, a line will be drawn.  To explicitly close polygons, use \fB\-L\fP.  Select a shade with \fB\-G\fP.  If \fB\-G\fP is set, \fB\-W\fP
will control whether the polygon outline is drawn or not.  If a symbol is selected, \fB\-G\fP and
\fB\-W\fP determines the fill color and outline/no outline, respectively.
The \fIPostScript\fP code is written to standard output.
.TP
\fIfiles\fP
List one or more file-names. If no files are given, \fBpsxyz\fP will read standard input.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx, or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps).  Same syntax as \fB\-Jx\fP.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-C
Give a color palette file and let symbol color be determined by the t-value in
the fourth column.  Must be used with \fB\-S\fP.  If used, then additional
fields are shifted over by one column (optional size would be in 5th rather than
4th field, etc.).
.TP
.B \-E
Sets the viewpoint's azimuth and elevation [180/90].
.TP
.B \-G
Select filling of polygons and symbols.
Append the shade (0\-255), color (r/g/b), or \fBp\fP|\fBp\fP\fIdpi\fP/\fIpattern\fP (polygons only) [Default is no fill].
Note when \fB\-M\fP is chosen, \fIpsxyz\fP will search for \fB\-G\fP and
\fB\-W\fP strings in all the subheaders and let any found values over-ride the command line settings.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Force closed polygons: will connect the endpoints of the line-sement(s) and draw polygons.
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
Do NOT skip symbols that fall outside map border [Default plots points inside border only].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-S
Plot symbols.  \fIsize\fP is symbol size in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).   The uppercase symbols
\fBA, C, D, H, I, S, T\fP are normalized to have the same area as a circle of given size,
while the corresponding lowercase symbols are circumscribed by the circle.
Choose between:
.TP
.B \-Sa
st\fBa\fPr.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sb
(\fBb\fP)ar extending from \fIbase\fP to y.  \fIsize\fP is bar width.  Append \fBu\fP
if \fIsize\fP is in x-units [Default is inch]. By default,
\fIbase\fP = 0.  Append b\fIbase\fP to change this value.
.TP
.B \-Sc
(\fBc\fP)ircle.  \fIsize\fP is diameter of circle.
.TP
.B \-Sd
(\fBd\fP)iamond.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Se
\fBe\fPllipse.  Direction (in degrees counterclockwise from horizontal), major_axis (in inch), and minor_axis (in inch) must be found in columns 4, 5, and 6.
.TP
.B \-SE
Same as \fB\-Se\fP, except azimuth (in degrees east of north) should be given instead of direction.  The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Se\fP leaves the directions
unchanged.)  Furthermore, the axes lengths must be given in km instead of inch.
.TP
.B \-Sf
\fBf\fPault.  Give distance gap between ticks and ticklength in inch.  If gap is
negative, it is interpreted to mean number of ticks instead.  Append \fBl\fP or \fBr\fP to draw tick on
the left or right side of line [Default is centered].  Upper case \fBL\fP or \fBR\fP draws a triangle
instead of line segment.
.TP
.B \-Sh
\fBh\fPexagon.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Si
\fBi\fPnverted triangle.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sl
\fBl\fPetter or text string.  Give size in inch, and append /\fIstring\fP after the size.  Note that the size is only approximate; no individual scaling
is done for different characters.  Remember to escape special characters like *.
.TP
.B \-So
c(\fBo\fP)lumn (3-D) extending from \fIbase\fP to z.  \fIsize\fP sets base width (Use \fIxsize/ysize\fP if not the same).  Append \fBu\fP if \fIsize\fP is in x-units
[Default is inch].  By default, \fIbase\fP = 0.  Append b\fIbase\fP to change this value.
.TP
.B \-Sp
(\fBp\fP)oint.  No size needs to be specified.
.TP
.B \-Ss
(\fBs\fP)quare.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-St
(\fBt\fP)riangle.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Su
c(\fBu\fP)be (3-D).  \fIsize\fP sets length of all sides in inch. Append \fBu\fP if \fIsize\fP
is in x-units [Default is inch].
.TP
.B \-Sv
(\fBv\fP)ector.  Direction and length (in inch) must be found in columns 4 and 5.
\fIsize\fP means \fIarrowwidth/headlength/headwidth\fP in (inch) [[Default is 0.03\fBi\fP/0.12\fBi\fP/0.1\fBi\fP inch].
By default arrow attributes remains invariant to the length
of the arrow.  To have the size of the vector scale down with decreasing size,
append \fBn\fP\fInorm\fP, where vectors shorter than \fInorm\fP will have their
attributes scaled by length/\fInorm\fP.
.TP
.B \-SV
Same as \fB\-Sv\fP, except azimuth should be given instead of direction.  The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Sv\fP leaves the directions
unchanged.)
.TP
.B \-Sx
(\fBx\fP)cross. \fIsize\fP is diameter of circumscribing circle.
.br
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75\fBi\fP/-0.75\fBi\fP)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Set pen attributes.  [Defaults: width = 1, color = 0/0/0, texture = solid].
Implicitly draws the outline of symbol with selected pen.
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (\fBa\fP1\fBi\fP,\fBa\fP1\fBi\fP)
for new plots, (0,0) for overlays].  Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
.TP
.B \-Z
For 3-D projections:  Sets the z-level of the basemap [0].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is the required number of columns given the settings].
.SH EXAMPLES
To plot blue columns (width = 0.5 inch) at the positions listed in the file heights.xyz on a
3-D projection of the space (0\-10), (0\-10), (0\-100),  with tickmarks every 2, 2, and 10,
viewing it from the southeast at 30 degree elevation, try:
.br
.sp
psxyz heights.xyz \fB\-R\fP0/10/0/10/0/100 \fB\-Jx\fP0.5\fBi \-Jz\fP0.05\fBi \-So\fP0.5\fBi\fP
\fB\-G\fP0/0/255 \fB\-B\fP2:XLABEL:/2:YLABEL:/10:ZLABEL::."3-D PLOT":15 \fB\-E\fP135/30 \fB\-Uc
\-W\fP \fB\-P\fP > heights.ps
.SH BUGS
No hidden line removal is employed for polygons and lines.  Symbols, however, are first sorted
according to their distance from the viewpoint so that nearby symbols will overprint more distant
ones should they project to the same x,y position.
.br
Header must be plotted separately using pstext.
.br
The \fB\-N\fP option does not adjust the BoundingBox information so you may
have to post-process the PostScript outout with epstool or ps2epsi to obtain
a correct BoundingBox.
.SH SEE ALSO
gmt, psbasemap, psxy
