.TH PSMASK l "1 July 1999"
.SH NAME
psmask \- To clip or mask areas of no data on a map
.SH SYNOPSIS
\fBpsmask\fP [\fIxyzfile\fP] \fB\-I\fP\fIdx\fP[\fBm|c\fP][\fI/dy\fP[\fBm|c\fP]] \fB\-J\fP\fIparameters\fP
\fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] [ \fB\-B\fP\fItickinfo\fP ]
[ \fB\-D\fP\fIdumpfile\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-F\fP ]
[ \fB\-G\fP\fIr/g/b\fP ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-K\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ] [ \fB\-O\fP ]
[ \fB\-P\fP ] [ \fB\-S\fP\fIradius\fP[\fBk\fP] ] [ \fB\-T\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ]
[ \fB\-V\fP ] [ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-c\fP\fIcopies\fP ]  [ \fB\-:\fP ]
[ \fB\-bi\fP[\fBs\fP][\fIn\fP] ]
.br
.sp
\fBpsmask\fP \fB\-C\fP [ \fB\-K\fP ] [ \fB\-O\fP ]
.SH DESCRIPTION
\fBpsmask\fP reads a (x,y,z) file [or standard input] and uses this information to find out
which grid cells are reliable.  Only gridcells which have one or more data points are considered
reliable.  As an option, you may specify a radius of influence. Then, all gridcells that are
within \fIradius\fP of a data point are considered reliable.  Furthermore, an option is provided to
reverse the sense of the test.  Having found the reliable/not reliable points, \fBpsmask\fP will
either paint tiles to mask these nodes (with the \fB\-T\fP) switch, or use contouring to create
polygons that will clip out regions of no interest.  When clipping is initiated, it will stay in
effect until turned off by a second call to \fBpsmask\fP using the \fB\-C\fP option.
.TP
\fIxyzfile\fP
File with (x,y,z) values (e.g., that was used to run \fBsurface\fP).  If no file
is given, standard input is read.  For binary files, see \fB\-b\fP.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to indicate minutes or \fBc\fP to indicate seconds.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx, or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
No space between the option flag and the associated arguments
.sp
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-C
Mark end of existing clip path.  No input file is needed.  Implicitly sets \fB\-O\fP.
.TP
.B \-D
Dumps out the resulting clipping polygons to disk.  Ignored if \fB\-T\fP is set.
If no dumpprefix is given we use mask (Files will be called mask_*.d).
.TP
.B \-E
Sets the viewpoint's azimuth and elevation for perspective plots [180/90]
.TP
.B \-F
Force pixel registration.  [Default is grid registration].
.TP
.B \-G
Paint the clip polygons [or tiles] with gray-shade or color [Default is no fill].
Specify the shade (0\-255) or color (r/g/b, each in 0\-255).
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
Not used with binary data.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN.
.TP
.B \-N
Invert the sense of the test, i.e. clip regions where there is data coverage.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-S
Sets radius of influence. Grid nodes within \fIradius\fP of a data point are considered reliable. [Default is 0, which
means that only grid cells with data in them are reliable].  Append \fBk\fP to indicated km,
also implying that \fB\-R \-I\fP are in degrees.
.TP
.B \-T
Plot tiles instead of clip polygons (Only works with \fB\-Jx\fP, \fB\-Jj\fP, \fB\-Jm\fP, \fB\-Jq\fP, and \fB\-Jy\fP).
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75\fBi\fP/-0.75\fBi\fP)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (\fBa\fP1\fBi\fP,\fBa\fP1\fBi\fP)
for new plots, (0,0) for overlays].  Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 2 input columns].
.SH EXAMPLES
To make an overlay \fIPostScript\fP file that will mask out the regions of a contour map
where there is no control data using clip polygons, try:
.br
.sp
psmask africa_grav.xyg \fB\-R\fP20/40/20/40 \fB\-I\fP5\fBm \-J\fPM10\fBi\fP \fB\-O \-K\fP > mask.ps
.br
.sp
The same example but this time we use tiling:
.br
.sp
psmask africa_grav.xyg \fB\-R\fP20/40/20/40 \fB\-I\fP5\fBm \-J\fPM10\fBi\fP \fB\-T \-O \-K\fP > mask.ps
.SH SEE ALSO
gmt, grdmask, surface, psbasemap, psclip
