.TH MAPPROJECT l "1 July 1999"
.SH NAME
mapproject \- Forward and Inverse map transformation of 2-D coordinates
.SH SYNOPSIS
\fBmapproject\fP \fIinfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP]
[ \fB\-C\fP ] [ \fB\-Dc|i|m|p\fP ] [ \fB\-F\fP[\fBk|m|n\fP] ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-I\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-S\fP ] [ \fB\-V\fP ] [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-bo\fP[\fBs\fP] ]
.SH DESCRIPTION
\fBmapproject\fP reads (longitude, latitude) positions from \fIinfiles\fP [or standard input] and
computes (x,y) coordinates using the specified map projection and scales.
Optionally, it can read (x,y) positions and compute (longitude, latitude) values
doing the inverse transformation.  This can be used to transform linear (x,y) points
obtained by digitizing a map of known projection to geographical coordinates.
Additional data fields are permitted after the first 2 columns which must have (longitude,latitude) or (x,y).
See option \fB\-:\fP on how to read (latitude,longitude) files.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIinfiles\fP
Data file(s) to be transformed.  If not given, standard input is read.
.TP
.B \-J
Selects the map projection.  The following character determines the projection.  If the
character is upper case then the argument(s) supplied as scale(s) is interpreted to be
the map width (or axis lengths) in
inch, else the scale argument(s) is the map scale (see its definition for each projection).
Choose one of the following projections (The \fBE\fP or \fBC\fP after projection names stands for
Equal-Area and Conformal, respectively):
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP or \fB\-JC\fP\fIlon0/lat0/width\fP (Cassini)
.br
	Give projection center and scale (1:xxxx or inch/degree).
.br
\fB\-Jj\fP\fIlon0/scale\fP or \fB\-JJ\fP\fIlon0/width\fP (Miller Cylindrical Projection)
.br
	Give the central meridian and scale (1:xxxx or inch/degree).
.br
\fB\-Jm\fP\fIparameters\fP (Mercator \fB[C]\fP).  Specify one of:
.br
	\fB\-Jm\fP\fIscale\fP or \fB\-JM\fP\fIwidth\fP
.br
		Give scale along equator (1:xxxx or inch/degree).
.br
	\fB\-Jm\fP\fIlon0/lat0/scale\fP or \fB\-JM\fP\fIlon0/lat0/width\fP
.br
		Give central meridian, standard latitude and scale along parallel (1:xxxx or inch/degree).
.br
\fB\-Jo\fP\fIparameters\fP (Oblique Mercator \fB[C]\fP).  Specify one of:
.br
	\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP or \fB\-JOa\fP\fIlon0/lat0/azimuth/width\fP
.br
		Set projection center, azimuth of oblique equator, and scale.
.br
	\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP or \fB\-JOb\fP\fIlon0/lat0/lon1/lat1/scale\fP
.br
		Set projection center, another point on the oblique equator, and scale.
.br
	\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP or \fB\-JOc\fP\fIlon0/lat0/lonp/latp/scale\fP
.br
		Set projection center, pole of oblique projection, and scale.
.br
	Give scale along oblique equator (1:xxxx or inch/degree).
.br
\fB\-Jq\fP\fIlon0/scale\fP or \fB\-JQ\fP\fIlon0/width\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
	Give the central meridian and scale (1:xxxx or inch/degree).
.br
\fB\-Jt\fP\fIparameters\fP (Transverse Mercator \fB[C]\fP).  Specify one of:
.br
	\fB\-Jt\fP\fIlon0/scale\fP or \fB\-JT\fP\fIlon0/width\fP
.br
		Give the central meridian and scale (1:xxxx or inch/degree).
.br
	\fB\-Jt\fP\fIlon0/lat0/scale\fP or \fB\-JT\fP\fIlon0/lat0/width\fP
.br
		Give projection center and scale (1:xxxx or inch/degree).
.br
\fB\-Ju\fP\fIzone/scale\fP or \fB\-JU\fP\fIzone/width\fP (UTM - Universal Transverse Mercator \fB[C]\fP)
.br
	Give the zone number and scale (1:xxxx or inch/degree).
.br
	Use negative zone numbers for the southern hemisphere.
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP or \fB\-JY\fP\fIlon0/lats/width\fP (Basic Cylindrical Projections \fB[E]\fP)
.br
	Give the central meridian, standard parallel, and scale (1:xxxx or inch/degree).
.br
	The standard parallel is typically one of these (but can be any value):
.br
	45	- The Peters projection
.br
	37.4	- The Trystan Edwards projection
.br
	30	- The Behrman projection
.br
	0	- The Lambert projection
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP or \fB\-JA\fP\fIlon0/lat0/width\fP (Lambert \fB[E]\fP).
.br
	\fIlon0/lat0\fP specifies the projection center.
.br
	Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
.br
	in inch from origin to the oblique latitude \fIlat\fP.
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP or \fB\-JE\fP\fIlon0/lat0/width\fP (Equidistant).
.br
	\fIlon0/lat0\fP specifies the projection center.
.br
	Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
.br
	in inch from origin to the oblique latitude \fIlat\fP.
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP or \fB\-JF\fP\fIlon0/lat0/horizon//width\fP (Gnomonic).
.br
	\fIlon0/lat0\fP specifies the projection center.
.br
	\fIhorizon\fP specifies the max distance from projection center (in degrees, < 90).
.br
	Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
.br
	in inch from origin to the oblique latitude \fIlat\fP.
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP or \fB\-JG\fP\fIlon0/lat0/width\fP (Orthographic).
.br
	\fIlon0/lat0\fP specifies the projection center.
.br
	Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
.br
	in inch from origin to the oblique latitude \fIlat\fP.
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP or \fB\-JS\fP\fIlon0/lat0/width\fP (General Stereographic \fB[C]\fP)
.br
	\fIlon0/lat0\fP specifies the projection center.
.br
	Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
.br
	in inch from origin to the oblique latitude \fIlat\fP.
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JB\fP\fIlon0/lat0/lat1/lat2/width\fP (Albers \fB[E]\fP)
.br
	Give projection center, two standard parallels, and scale (1:xxxx or inch/degree).
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JD\fP\fIlon0/lat0/lat1/lat2/width\fP (Equidistant)
.br
	Give projection center, two standard parallels, and scale (1:xxxx or inch/degree).
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JL\fP\fIlon0/lat0/lat1/lat2/width\fP (Lambert \fB[C]\fP)
.br
	Give origin, 2 standard parallels, and scale along these (1:xxxx or inch/degree).
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP or \fB\-JH\fP\fIlon0/width\fP (Hammer \fB[E]\fP)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Ji\fP\fIlon0/scale\fP or \fB\-JI\fP\fIlon0/width\fP (Sinusoidal \fB[E]\fP)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP or \fB\-JK\fP[\fBf|s\fP]\fIlon0/width\fP (Eckert IV (f) and VI (s) \fB[E]\fP)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Jn\fP\fIlon0/scale\fP or \fB\-JN\fP\fIlon0/width\fP (Robinson)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Jr\fP\fIlon0/scale\fP \fB\-JR\fP\fIlon0/width\fP (Winkel Tripel)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Jv\fP\fIlon0/scale\fP or \fB\-JV\fP\fIlon0/width\fP (Van der Grinten)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Jw\fP\fIlon0/scale\fP or \fB\-JW\fP\fIlon0/width\fP (Mollweide \fB[E]\fP)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP or \fB\-JP\fP\fIwidth\fP (Linear projection for polar (theta,r) coordinates)
.br
	Give scale in inch/r-unit.
.br
\fB\-Jx\fP\fIx-scale\fP[\fI/y-scale\fP] or \fB\-JX\fP\fIwidth\fP[\fI/height\fP]
.br
\fIscale\fP [or \fIwidth\fP] can be any of the following 3 types:
.br
	\fB\-Jx\fP\fIscale\fP		- Regular linear scaling.
.br
	\fB\-Jx\fP\fIscale\fP\fBl\fP	- Take log10 of values before scaling.
.br
	\fB\-Jx\fP\fIscale\fP\fBp\fP\fIpower\fP	- Raise values to \fIpower\fP before scaling.
.br
Give \fIx-scale\fP in inch/x-unit and \fIy-scale\fP in inch/y-unit.
(\fIy-scale\fP = \fIx-scale\fP if not specified separately).  Use negative
scale(s) to reverse the direction of an axis (e.g., to have y be positive down).
.br
.sp
Append \fBd\fP if x and y are geographical coordinates in degrees.
Default axes lengths (see gmtdefaults) can be invoked
using \fB\-JXh\fP (for landscape); \fB\-JXv\fP (for portrait) will swap the x- and y-axes lengths.
The \fBGMT\fP default unit for this installation is inch.  However, you may
change this by editing your .gmtdefaults file(s) (run gmtdefaults to create one
if you don't have it).
.br
	The ellipsoid used in the map projections is user-definable by editing the .gmtdefaults file
in your home directory.  13 commonly used ellipsoids and a spheroid are currently
supported, and users may also specify their own ellipsoid parameters (see man gmtdefaults for more details).
\fBGMT\fP default is WGS-84.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
.TP
\fIinfile(s)\fP
input file(s) with 2 or more columns. If no file(s) is given, mapproject will read standard input.
.TP
.B \-C
Set center of projected coordinates to be at map projection center [Default is lower left corner].
.TP
.B \-D
Temporarily override MEASURE_UNIT and use \fBc\fP (cm), \fBi\fP (inch),
\fBm\fP (meter), or \fBp\fP (points) instead.
.TP
.B \-F
Force 1:1 scaling, i.e., output (or input, see \fB\-I\fP) data are in actual projected meters.  To specify other units,
append \fBk\fP (km), \fBm\fP (mile),\fBn\fP (nautical mile), \fBi\fP (inch), \fBc\fP (cm), or \fBp\fP (points).
Without \fB\-F\fP, the output (or input, see \fB\-I\fP) are in the units specified by MEASURE_UNIT (but see \fB\-D\fP).
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
Do the Inverse transformation, i.e. get (longitude,latitude) from (x,y) data.
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN.
.TP
.B \-S
Suppress points that fall outside the region.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 2 input columns]
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is double].
.SH EXAMPLES
To transform a file with (longitude,latitude) into (x,y) positions in inch on
a Mercator grid for a given scale of 0.25 inch per degree, run
.br
.sp
mapproject lonlatfile \fB\-R\fP20/50/12/25 \fB\-Jm\fP0.25\fBi\fP > xyfile
.br
.sp
To transform several 2-column, binary, double precision files with (latitude,longitude) into (x,y) positions in inch on
a Transverse Mercator grid (central longitude 75W) for scale = 1:500000 and suppress those points
that would fall outside the map area, run
.br
.sp
mapproject tracks.* \fB\-R\fP-80/-70/20/40 \fB\-Jt\fP-75/1:500000 \fB\-:\fP \fB\-S \-bo \-bi\fP\fI2\fP > tmfile.b
.br
.SH RESTRICTIONS
The rectangular input region set with \fB\-R\fP will in general be mapped into a
non-rectangular grid.  Unless \fB\-C\fP is set, the leftmost point on this grid has xvalue = 0.0, and the
lowermost point will have yvalue = 0.0. Thus, before you digitize a map, run the
extreme map coordinates through \fBmapproject\fP using the appropriate scale and see
what  (x,y) values they are mapped onto.  Use these values when setting up for
digitizing in order to have the inverse transformation work correctly, or alternatively,
use \fIawk\fP to scale and shift the (x,y) values before transforming.
.SH ELLIPSOIDS AND SPHEROIDS
GMT will use ellipsoidal formulae if they are implemented and the user have
selected an ellipsoid as the reference shape (see gmtdefaults).  The user
needs to be aware of a few potential pitfalls: (1)  For some projections,
such as Transverse Mercator, Albers, and Lamberts conformal conic we use the
ellipsoidal expressions when the areas mapped are small, and switch to the
spherical expressions (and substituting the appropriate auxillary latitudes)
for larger maps.  The ellipsoidal formulae are used are follows: (a) Transverse
Mercator: When all points are within 10 degrees of central meridian, (b) Conic
projections when longitudinal range is less than 90 degrees, (c) Cassini
projection when all points are within 4 degrees of central meridian. (2) When
you are trying to match some historical data (e.g., coordinates obtained with
a certain projection and a certain reference ellipsoid) you may find that GMT
gives results that are slightly different.  One likely source of this mismatch
is that older calculations often used less significant digits.  For instance,
Snyder's examples often use the Clarke 1866 ellipsoid (defined by him as
having a flattening f = 1/294.98).  From f we get the eccentricity squared to
be 0.00676862818 (this is what GMT uses), while Snyder rounds off and uses
0.00676866.  This difference gan give discrepancies of several 10 of cm.
If you need to reproduce coordinates projected with this slightly different
eccentricity, you should specify your own ellipsoid with the same parameters
as Clarke 1866, but with f = 1/294.97861076.
.SH SEE ALSO
gmtdefaults, gmt, project
.SH REFERENCES
Snyder, J. P., 1987, Map Projections \- A Working Manual, U.S. Geological Survey Prof. Paper 1395.
.br
