.TH GMTDEFAULTS l "1 July 1999"
.SH NAME
gmtdefaults \- To list current \fBGMT\fP defaults
.SH SYNOPSIS
\fBgmtdefaults\fP \fB\-D\fP | \fB\-L\fP
.SH DESCRIPTION
\fBgmtdefaults\fP lists the
\fBGMT\fP parameter defaults if the option \fB\-D\fP is used.  To change some of the settings,
use any texteditor to edit the file .gmtdefaults in your home or current directory.  If you do not have
this file in your home or current directory, run \fBgmtdefaults\fP -D > ~/.gmtdefaults to get the system settings.
.TP
.B \-D
Print the system \fBGMT\fP defaults to standard output.
.TP
.B \-L
Print the user's currently active defaults to standard output.
.SH \fBGMT\fP PARAMETERS
The following is a list of the 57 parameters that are user-definable in \fBGMT\fP.  The
parameter names are always given in UPPER CASE.  The parameter values are
case-insensitive unless otherwise noted.  The
system defaults are given in brackets [ ].  Those marked \fB*\fP can be set on the command
line as well (the corresponding option is given in parentheses).  Note that distances and
lengths below are given in inch.  You can explicitly specify the unit used for distances and
lengths by appending \fBc\fP (cm), \fBi\fP (inch), \fBm\fP (meter), or \fBp\fP {points).
When no unit is indicated the value will be assumed to be in the unit set by \fBMEASURE_UNIT\fP.
Note that the printer resolution DOTS_PR_INCH is always the number of dots or pixels per inch.
Several parameters take only TRUE or FALSE.
.TP
.B ANOT_MIN_ANGLE
If the angle between the map boundary and the annotation baseline is less than this minimum value (in degrees), the
annotation is not plotted (this may occur for certain oblique projections.)  Give a value in the
range 0\-90. [20]
.TP
.B ANOT_FONT
Font used for tick mark annotations etc [Helvetica].  Specify either the font number or
the font name (case sensitive!).  The 35 available fonts are:
.br
	0  Helvetica
.br
	1  Helvetica-Bold
.br
	2  Helvetica-Oblique
.br
	3  Helvetica-BoldOblique
.br
	4  Times-Roman
.br
	5  Times-Bold
.br
	6  Times-Italic
.br
	7  Times-BoldItalic
.br
	8  Courier
.br
	9  Courier-Bold
.br
	10 Courier-Oblique
.br
	11 Courier-BoldOblique
.br
	12 Symbol
.br
	13 AvantGarde-Book
.br
	14 AvantGarde-BookOblique
.br
	15 AvantGarde-Demi
.br
	16 AvantGarde-DemiOblique
.br
	17 Bookman-Demi
.br
	18 Bookman-DemiItalic
.br
	19 Bookman-Light
.br
	20 Bookman-LightItalic
.br
	21 Helvetica-Narrow
.br
	22 Helvetica-Narrow-Bold
.br
	23 Helvetica-Narrow-Oblique
.br
	24 Helvetica-Narrow-BoldOblique
.br
	25 NewCenturySchlbk-Roman
.br
	26 NewCenturySchlbk-Italic
.br
	27 NewCenturySchlbk-Bold
.br
	28 NewCenturySchlbk-BoldItalic
.br
	29 Palatino-Roman
.br
	30 Palatino-Italic
.br
	31 Palatino-Bold
.br
	32 Palatino-BoldItalic
.br
	33 ZapfChancery-MediumItalic
.br
	34 ZapfDingbats
.TP
.B ANOT_FONT_SIZE
Font size (> 0) in points for map annotations.  [14]
.TP
.B ANOT_OFFSET
Distance (> 0) from end of tickmark to start of annotation [0.075 inch].
.TP
.B BASEMAP_AXES
Sets which axes to draw and annotate.  Case sensitive: Upper case means both draw and annotate, lower case
means draw axis only.  [WESN].
.TP
.B BASEMAP_FRAME_RGB
Color used to draw map boundaries and annotations.
Give a red/green/blue triplet, with each element in the 0\-255 range.
[0/0/0] (black).
.TP
.B BASEMAP_TYPE
Choose between plain and fancy (thick boundary, alternating black/white frame)  [fancy].
For some map projections (e.g., Oblique Mercator), plain is the only option even if fancy is set as default.
.TP
.B COLOR_BACKGROUND
Color used for the background of images (i.e., when z < lowest colortable entry).
Give a red/green/blue triplet, with each element in the 0\-255 range. [0/0/0] (black)
.TP
.B COLOR_FOREGROUND
Color used for the foreground of images (i.e., when z > highest colortable entry).
Give a red/green/blue triplet, with each element in the 0\-255 range. [255/255/255] (write)
.TP
.B COLOR_IMAGE
Selects which operator to use when rendering bit-mapped color images.  Due to the
lack of the colorimage operator in some PostScript implementations, \fBGMT\fP offers 2 different
options:
.br
.sp
	adobe (Adobe's colorimage definition)  [Default].
.br
	tiles (Plot image as many individual rectangles).
.br
.TP
.B COLOR_MODEL
Selects if color palette files contain rgb values (r,g,b in 0-255 range) or HSV values
(h = 0-360, s,v in 0-1 range)  [rgb].
.TP
.B COLOR_NAN
Color used for the non-defined areas of images (i.e., where z == NaN).
Give a red/green/blue triplet, with each element in the 0\-255 range. [128/128/128] (gray)
.TP
.B D_FORMAT
Output format (C language syntax) to be used when printing double precision floating point numbers  [%lg].
.TP
.B DEGREE_FORMAT
Output format to be used when annotating map boundaries.  Choose between six formats:
.br
.sp
	0	Longitudes go from 0 to 360, latitudes from -90 to 90 [Default].
.br
	1	Longitudes go from -180 to 180, latitudes from -90 to 90.
.br
	2	Longitudes are unsigned 0 to 180, latitudes unsigned 0 to 90.
.br
	3	Same as 2, but with letters W, E, S, or N appended as appropriate.
.br
	4	Same as 0, with decimal degrees instead of degrees, minutes, and seconds.
.br
	5	Same as 1, with decimal degrees instead of degrees, minutes, and seconds.
.TP
.B DOTS_PR_INCH
Resolution of the plotting device (dpi).  Note that in order to be as compact as possible,
\fBGMT\fP PostScript output uses integer formats only so the resolution should be
set depending on what output device you are using.  E.g, using 300 and sending the output to
a Linotype 300 phototypesetter (2470 dpi) will not take advantage of the extra resolution (i.e.,
positioning on the page and line thicknesses are still only done in steps of 1/300 inch; of course, text will look smoother)  [300].
.TP
.B ELLIPSOID
The (case sensitive) name of the ellipsoid used for the map projections  [WGS-84].  Choose among
.br
.sp
WGS-84		1984 World Geodetic System
.br
GRS-80		1980 International Geodetic Reference System
.br
WGS-72		1972 World Geodetic System
.br
WGS-66		1966 World Geodetic System
.br
Australian	1965 Used down under
.br
Krassovsky	1940 Used in the Soviet Union
.br
International	1924 Worldwide use
.br
Hayford-1909	1909 Same as the International 1924
.br
Clarke-1880	1880 Most of Africa, France
.br
Clarke-1866	1866 North America, the Phillipines
.br
Airy		1830 Great Britain
.br
Bessel		1841 Central Europe, Chile, Indonesia
.br
Everest		1830 India, Burma, Pakistan, Afghanistan, Thailand, etc.
.br
Sphere		1980 The mean radius in GRS-80 (for spherical/plate tectonics applications)
.br
.sp
Note that for some global projections, \fBGMT\fP may default to GRS-80 Sphere regardless
of ellipsoid actually chosen.  A warning will be given when this happens.  If a different
ellipsoid name than those mentioned here is given, \fBGMT\fP will attempt to open this
name as a file and read the ellipsoid name, year, major-axis (in m), minor-axis (in m), and flattening from
the first record, where the fields must be separated by white-space (not commas).  This way a
custom ellipsoid (e.g., those used for other planets) may be used.
.TP
.B FRAME_PEN
Thickness of pen used to draw plain map frame in dpi units or points (append p)  [5].
.TP
.B FRAME_WIDTH
Width (> 0) of map borders for fancy map frame [0.075 inch].
.TP
.B GLOBAL_X_SCALE
Global x-scale (> 0) to apply to plot-coordinates before plotting.  Normally used to shrink
the entire output down to fit a specific height/width  [1.0].
.TP
.B GLOBAL_Y_SCALE
Same, but for y-coordinates  [1.0].
.TP
.B GRID_CROSS_SIZE
Size (>= 0) of grid cross at lon-lat intersections.  0 means draw continuous gridlines
instead [0 inch].
.TP
.B GRID_PEN
Pen thickness used to draw grid lines in dpi units or points (append p) [1].
.TP
.B GRIDFILE_SHORTHAND
If TRUE, all gridfile names are examined to see if they use the file extension
shorthand discussed in Section 4.17 of the GMT Technical Reference and Cookbook.
If FALSE, no filename expansion is done [FALSE].
.TP
.B HEADER_FONT
Font to use when plotting headers.  See ANOT_FONT for available fonts  [Helvetica].
.TP
.B HEADER_FONT_SIZE
Font size (> 0) for header in points  [36].
.TP
.B HSV_MIN_SATURATION
Minimum saturation (0\-1) assigned for most negative intensity value [1.0].
.TP
.B HSV_MAX_SATURATION
Maximum saturation (0\-1) assigned for most positive intensity value [0.1].
.TP
.B HSV_MIN_VALUE
Minimum value (0\-1) assigned for most negative intensity value [0.3].
.TP
.B HSV_MAX_VALUE
Maximum value (0\-1) assigned for most positive intensity value [1.0].
.TP
.B INTERPOLANT
Determines if linear (linear), Akima's spline (akima), or natural cubic spline (cubic) should
be used for 1-D interpolations in various programs [akima].
.TP
.B IO_HEADER * (\-H)
Specifies whether input/output ASCII files have header record(s) or not  [FALSE].
.TP
.B N_HEADER_RECS
Specifies how many header records to expect if \fB\-H\fP is turned on  [1].
.TP
.B LABEL_FONT
Font to use when plotting labels below axes.  See ANOT_FONT for available fonts  [Helvetica].
.TP
.B LABEL_FONT_SIZE
Font size (> 0) for labels in points  [24].
.TP
.B LINE_STEP
Determines the maximum length (> 0) of individual straight line-segments when drawing arcuate lines  [0.01 inch]
.TP
.B MAP_SCALE_FACTOR
Sets the central scale factor (> 0) used for the Polar Stereographic and Transverse Mercator projections.
Typically, it is set to 0.9996 to minimize areal distortion  [0.9996].
.TP
.B MAP_SCALE_HEIGHT
Sets the height (> 0) on the map of the map scalebars drawn by various programs [0.075 inch].
.TP
.B MEASURE_UNIT
Sets the unit length.  Choose between cm, inch, m, and point.  [inch].  Note
that, in GMT, one point is defined as 1/72 inch (the \fIPostScript\fP definition), while it
is often defined as 1/72.27 inch in the typesetting industry.  There is no
universal definition.
.TP
.B N_COPIES * (\-c)
Number of plot copies to make  [1].
.TP
.B OBLIQUE_ANOTATION
This option only applies to oblique projections.
If set to 0, longitudes will be annotated on the lower and upper boundaries only, and latitudes will be
annotated on the left and right boundaries only.  1 plots annotations wherever a gridline crosses the
map boundaries  [1].
.TP
.B PAGE_COLOR
Sets the color of the imaging background, i.e., the paper.
Give a red/green/blue triplet, with each element in the 0\-255 range. [255/255/255] (white)
.TP
.B PAGE_ORIENTATION * (\-P)
Sets the orientation of the page.  Choose portrait or landscape  [landscape].
.TP
.B PAPER_MEDIA
Sets the physical format of the current plot paper [Letter].  The following
formats (and their widths and heights in points) are recognized (Additional
site-specific formats may be specified in
the gmtmedia.d file in $GMTHOME/lib; see that file for details):
.br
.sp
	Media	width	height
.br
	A0	2380	3368
.br
	A1	1684	2380
.br
	A2	1190	1684
.br
	A3	842	1190
.br
	A4	595	842
.br
	A5	421	595
.br
	A6	297	421
.br
	A7	210	297
.br
	A8	148	210
.br
	A9	105	148
.br
	A10	74	105
.br
	B0	2836	4008
.br
	B1	2004	2836
.br
	B2	1418	2004
.br
	B3	1002	1418
.br
	B4	709	1002
.br
	B5	501	709
.br
	archA	648	864
.br
	archB	864	1296
.br
	archC	1296	1728
.br
	archD	1728	2592
.br
	archE	2592	3456
.br
	flsa	612	936
.br
	halfletter	396	612
.br
	note	540	720
.br
	letter	612	792
.br
	legal	612	1008
.br
	11x17	792	1224
.br
	ledger	1224	792
.br
.sp
To force the printer to request a manual paper feed, append '-' to the media
name, e.g., A3- will require the user to insert a A3 paper into the printer's
manual feed slot.  To indicate you are making an EPS file, append '+' to the
media name.  Then, GMT will attempt to issue a tight bounding box [Default is
the paper dimension].
.TP
.B PSIMAGE_FORMAT
Determines whether images created in PostScript should use hexadecimal (i.e., ascii)
or binary format.  The latter takes up only half as much space and executes faster but may choke
some printers, especially those off serial ports.  Select hex or bin [hex].
.TP
.B TICK_LENGTH
The length of a tickmark.  Normally, tickmarks are drawn on the outside of
the map boundaries.  To select interior tickmarks, use a negative tick_length [0.075 inch].
.TP
.B TICK_PEN
The pen thickness to be used for tickmarks in dpi units or points (append p) [2].
.TP
.B UNIX_TIME * (\-U)
Specifies if a UNIX system time stamp should be plotted
at the lower left corner of the plot  [FALSE].
.TP
.B UNIX_TIME_POS * (\-U)
Sets the position of the UNIX time stamp relative to the current plots lower left corner [-0.75i/-0.75i].
.TP
.B VECTOR_SHAPE
Determines the shape of the head of a vector.   Normally (i.e., for vector_shape = 0),
the head will be triangular, but can be changed to an arrow (1).  Intermediate
settings gives something in between  [0].
.TP
.B VERBOSE * (\-V)
Determines if \fBGMT\fP programs should display run-time information or run silently  [FALSE].
.TP
.B WANT_EURO_FONT
Determines if \fBGMT\fP \fIPostScript\fP output should include font re-encoding for accented European characters.  See Cookbook section 4.15 and Appendix H for details [FALSE].
.TP
.B X_AXIS_LENGTH
Sets the default length (> 0) of the x-axis [9 inch].
.TP
.B Y_AXIS_LENGTH
Sets the default length (> 0) of the y-axis [6 inch].
.TP
.B X_ORIGIN * (\-X)
Sets the x-coordinate of the origin on the paper for a new plot [1 inch].
For an overlay, the default offset is 0.
.TP
.B Y_ORIGIN * (\-Y)
Sets the y-coordinate of the origin on the paper for a new plot [1 inch].
For an overlay, the default offset is 0.
.TP
.B XY_TOGGLE * (\-:)
Set if the first two columns of input files contain (latitude,longitude) or (y,x) rather than the expected
(longitude,latitude) or (x,y)  [FALSE].
.TP
.B Y_AXIS_TYPE
Determines if the annotations for a y-axis (for linear projections) should be plotted horizontally (hor_text)
or vertically (ver_text)  [hor_text].
.SH EXAMPLES
To get a copy of the \fBGMT\fP parameter defaults in your home directory, run
.br
.sp
gmtdefaults \fB\-D\fP > ~/.gmtdefaults
.br
.sp
You may now change the settings by editing this file using a text editor of your choice, or
use \fBgmtset\fP to change specified parameters on the command line.
.SH BUGS
If you have typographical errors in your .gmtdefaults file(s), a warning message will be
issued, and the \fBGMT\fP defaults for the affected parameters will be used.
.SH SEE ALSO
gmt, gmtset
