.TH GRDCONTOUR l "1 July 1999"
.SH NAME
grdcontour \- contouring of 2-D gridded data sets
.SH SYNOPSIS
\fBgrdcontour\fP \fIgrdfile\fP \fB\-C\fP\fIcont_int\fP \fB\-J\fP\fIparameters\fP [ \fB\-A\fP[\fB-\fP][\fIanot_int\fP][\fBf\fP\fIfont_size\fP][\fBa\fP\fIangle\fP][\fI/r/g/b\fP][\fBo\fP]] ]
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-D\fP\fIdumpfile\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-G\fP\fIgap/width\fP ]
[ \fB\-K\fP ] [ \fB\-L\fP\fIlow/high\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP[\fIunit\fP] ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-Q\fP\fIcut\fP ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] ]
[ \fB\-S\fP\fIsmoothfactor\fP ] [ \fB\-T\fP[\fB+|-\fP][\fIgap/length\fP][\fB:\fP\fILH\fP] ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V \fP ] [ \fB\-W\fP[\fB+\fP][\fItype\fP]\fIpen\fP ]
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP[\fIfactor\fP[/\fIshift\fP]][\fBp\fP] ] [ \fB\-c\fP\fIcopies\fP ]
[ \fB\-bo\fP[\fBs\fP] ]
.SH DESCRIPTION
\fBgrdcontour\fP reads a 2-D gridded file and produces a contour map by tracing
each contour through the grid.  As an option, the x/y/z positions of the contour lines may be dumped to
a single multisegment file or many separate files.  \fIPostScript\fP code is generated and sent to standard output.  Various options
that affect the plotting are available.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIgrdfile\fP
2-D gridded data set to be contoured
.TP
.B \-C
The contours to be drawn may be specified in one of three possible ways:
.br
If \fIcont_int\fP has the suffix ".cpt" and can be opened as a file, it is assumed
to be a color palette table.  The color boundaries are then used as contour levels.
If the cpt-file has anotation flags in the last column then those contours will be
anotated.  By default no contours are labeled; use \fB\-A\fP to anotate all contours.
.br
If \fIcont_int\fP is a file but not a cpt-file, it is expected to contain contour levels
in column 1 and a C(ontour) OR A(nnotate) in col 2. The levels marked C (or c) are contoured,
the levels marked A (or a) are contoured and annotated.  Optionally, a third column may be
present and contain the fixed anotation angle for this contour level.
.br
If no file is found, then \fIcont_int\fP is
interpreted as a constant contour interval.  If \fB\-A\fP is set and \fB\-C\fP is not, then
the contour interval is set equal to the specified anotation interval.
.br
If a file is given and \fB\-T\fP is set,
then only contours marked with upper case C or A will have tickmarks.
.TP
.B \-J
Selects the map projection. Scale is cm/degree, 1:xxxxx, or width in cm (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
\fIanot_int\fP is annotation interval in data units.  Ignored if contour levels are given in a file.
[Default is no annotations].  Several options can be set to modify the form of the annotation.  Give - to disable all anotations.
Append f\fIfont_size\fP to change font size [9], append \fI/r/g/b\fP to change color of text fill box
[PAGE_COLOR], append a\fIangle\fP to fix annotation angle [Default follows contour], and append \fBo\fP to draw the outline of the surrounding text box [Default is no outline].
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-D
Dump the (x,y,z) coordinates of each contour to separate files, one for each contour segment. The
files will be named \fIdumpfile_cont_segment[_i]\fP.xyz (or \fI.b\fP is \fB\-b\fP is selected), where \fIcont\fP is the contour value and
\fIsegment\fP is a running segment number for each contour interval (for closed contours we append _i.)
However, when \fB\-M\fP
is used in conjunction with \fB\-D\fP a single multisegment file is created instead.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation for perspective view [180/90]
.TP
.B \-G
\fIgap\fP is distance in cm between each annotation along the same contour.
\fIwidth\fP is number of points over which to estimate the best fitting slope
for contour labels  [Default is 10c/10].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Limit range: Do not draw contours for data values below \fIlow\fP or above \fIhigh\fP.
.TP
.B \-M
When used in conjunction with \fB\-D\fP a single multisegment file is created, and
each contour section is preceeded by a header record whose first column is \fIflag\fP
followed by the contour level.
.TP
.B \-N
Appends \fIunit\fP to all contour labels (assuming \fB\-A\fP is set).  If no name is specified, the unit given in
the \fIgrdfile\fP will be used [Default is no unit].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-Q
Do not draw contours with less than \fIcut\fP number of points [Draw all contours].
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
[Default is region defined in the grd file].
.TP
.B \-S
Used to resample the contour lines at roughly every (gridbox_size/\fIsmoothfactor\fP) interval.
.TP
.B \-T
Will draw tickmarks pointing in the downward direction every \fIgap\fP along the innermost closed contours.  Append \fIgap\fP and tickmark length (in cm) or use defaults [0.5c/0.1c].
User may choose to tick only local highs or local lows by specifying \fB\-T+\fP or \fB\-T-\fP, respectively.  Appending :LH will plot the characters L and H at the center of closed
innermost contours (local lows and highs).  L and H can be any single character (e.g., LH, -+, etc.)
If a file is given by \fB\-C\fP and \fB\-T\fP is set,
then only contours marked with upper case C or A will have tickmarks [and anotation].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in cm [Default is (-2\fBc\fP/-2\fBc\fP)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
\fItype\fP, if present, can be 'a' for annotated contours or 'c' for regular contours [Default].
\fIpen\fP sets the attributes for the particular line.  Default values for annotated contours:
width = 3, color = black, texture = solid.  Regular contours have default width = 1.  If the
\fB+\fP flag is specified then the color of the contour lines are taken from the cpt file (see \fB\-C\fP).
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) cm  [Default is (\fBa\fP2.5\fBc\fP,\fBa\fP2.5\fBc\fP)
for new plots, (0,0) for overlays].  Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
.TP
.B \-Z
Use to subtract \fIshift\fP from the data and multiply the results by \fIfactor\fP before contouring starts [1/0].
(Numbers in \fB\A, \-C, \-L\fP refer to values after this scaling has occurred.)
Append \fBp\fP to indicate
that this grid file contains z-values that are periodic in 360 degrees (e.g.,
phase data, angular distributions) and that
special precautions must be taken when determining 0-contours.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is double].
.SH EXAMPLES
To contour the file hawaii_grav.grd every 25 mGal on a Mercator map at 1.5 cm/degree, annotate
every 50 mGal (using fontsize = 10), using 1 degree tickmarks, and draw 30 minute gridlines, try
.br
.sp
grdcontour hawaii_grav.grd \fB\-Jm\fP1.5\fBc\fP \fB\-C\fP25 \fB\-A\fP50\fBf\fP10 \fB\-B\fP1\fBg\fP30\fBm\fP > hawaii_grav.ps
.br
.sp
To contour the file image.grd using the levels in the file cont.d on a linear projection at 0.1 cm/x-unit
and 50 cm/y-unit, using 20 (x) and 0.1 (y) tickmarks, smooth the contours a bit, use "RMS Misfit" as
plot-title, use a thick red pen for annotated contours, and a thin, dashed, blue pen for the rest, try
.br
.sp
grdcontour image.grd \fB\-Jx\fP0.1\fBc\fP/50.0\fBc\fP \fB\-C\fPcont.d \fB\-S\fP4 \fB\-B\fP20/0.1:."RMS Misfit":
\fB\-Wa\fP5/255/0/0 \fB\-Wc\fP1/0/0/255\fBta\fP | lpr
.SH BUGS
The text-outline box has not been implemented for perspective view plots.  Anotations will plot correctly, but contours will go right through the text.
.br
The labeling of local highs and lows may plot outside the innermost contour since only the mean value
of the contour coordinates is used to position the label.
.br
There are too many options.
.SH SEE ALSO
gmt, psbasemap, grdimage, grdview, pscontour
