REM		GMT EXAMPLE 16
REM
REM		@(#)job16.bat	1.5  06/08/99
REM
REM Purpose:	Illustrates interpolation methods using same data as Example 12.
REM GMT progs:	makecpt, surface, triangulate
REM DOS calls:	gawk, echo, del
REM Remark:	Differs from UNIX versions in that makecpt uses hardwired limits
REM
REM First make a cpt file as in example 12:
REM
echo GMT EXAMPLE 16
set master=y
if exist job16.bat set master=n
if %master%==y cd ex16
makecpt -Crainbow -T675/975/25 > topo.cpt
REM
REM Now illustrate various means of contouring, using triangulate and surface.
REM
gmtset MEASURE_UNIT INCH ANOT_FONT_SIZE 9
REM
pscontour -R0/6.5/-0.2/6.5 -Jx0.45i -P -K -Y4.75i -Ba2f1WSne table_5.11 -Ctopo.cpt -I > example_16.ps
echo 3.25 7 18 0 4 CB pscontour (triangulate) | pstext -R -Jx -O -K -N >> example_16.ps
REM
surface table_5.11 -R -I0.1 -Graws0.grd
grdview raws0.grd -R -Jx -Ba2f1WSne -Ctopo.cpt -Qs -O -K -X3.5i >> example_16.ps
echo 3.25 7 18 0 4 CB surface (tension = 0) | pstext -R -Jx -O -K -N >> example_16.ps
REM
surface table_5.11 -R -I0.1 -Graws5.grd -T0.5
grdview raws5.grd -R -Jx -Ba2f1WSne -Ctopo.cpt -Qs -O -K -Y-3.75i -X-3.5i -U"Example 16 in Cookbook" >> example_16.ps
echo 3.25 7 18 0 4 CB surface (tension = 0.5) | pstext -R -Jx -O -K -N >> example_16.ps
REM
triangulate table_5.11 -Grawt.grd -R -I0.1 > null
grdfilter rawt.grd -Gfiltered.grd -D0 -Fc1
grdview filtered.grd -R -Jx -Ba2f1WSne -Ctopo.cpt -Qs -O -K -X3.5i >> example_16.ps
echo 3.25 7 18 0 4 CB triangulate @~\256@~ grdfilter | pstext -R -Jx -O -K -N >> example_16.ps
echo 3.2125 7.5 32 0 4 CB Gridding of Data | pstext -R0/10/0/10 -Jx1i -O -N -X-3.5i >> example_16.ps
del topo.cpt
del *.grd
del .gmt*
if %master%==y cd ..
