#!/bin/bash
#
#	@(#)do_examples.bash	1.6  12/14/98
#
# Bash script to test all GMT examples (bash versions).

# First determine if awk is buggy:

result=`echo 1 | awk '{print sin($1)}'`
if [ $result = 1 ]; then
	answer=`which nawk`
	if [ $#answer = 1 ]; then
		export AWK=nawk
	else
		export AWK=gawk
	fi
else
	export AWK=awk
fi

# Loop over all examples and run each job

for dir in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20
do
	if [ -e ex${dir}/job${dir}.bash ]; then
		echo -n "Doing example ${dir}..."
		cd ex${dir}
		bash job${dir}.bash
		cd ..
		echo "done"
	fi
done
echo "Completed all examples"
