#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "fluidss.h"

/* #define QUERY "crime and punishment" */
#define QUERY "*"

#define EBUFSIZE 4096

void myPrintError( struct flu_searcher_t *fs, unsigned zint_t errorCode, const char *name)
{
  const char *errorString = fluSearcherErrorString( fs, errorCode, name);
  strncpy( (char *) fs->info, errorString, EBUFSIZE);
  ((char *) fs->info)[EBUFSIZE-1] = '\0';
}

void main( void )
{
  struct flu_searcher_t searcher;
  const char *indexFile = "index.flu";
  struct flu_searcher_result_t *result;
  char buf[EBUFSIZE];

  fluInit();

/* ⠢  */
  if( !fluSearcherInit(             /* 樠... */
         &searcher,                    /* ᪮ */
         myPrintError,                 /* 訡   buf */
         NULL,                         /* ⠥,    */
         buf                           /* ⥫쭠 ଠ */
       ) ||
      !fluSearcherSetParams(        /* ࠬ ᪠... */
         &searcher,                    /* ᪮ */
         FS_AREA_CONTENT | FS_AREA_TITLE, /*  ᪠ */
         0,                            /* 䫠 ᪠ */
         20,                           /* ய  20 १⮢ */
         10                            /*  ᫥騥 10 १⮢ */
       ) ||
      !fluSearcherSetQuery(         /* ⠭  */
         &searcher,                    /* ᪮ */
         QUERY                         /* ᮡ⢥  */
       ) )
  {
    fluSearcherFree( &searcher );
    fprintf( stderr, "訡 樠樨 ᪮.\n%s\n", buf);
    exit( -1 );
  }

/* ⢫塞  */
  if( !fluSearcherMakeSearch(       /*  */
         &searcher,                    /* ᪮ */
         1,                            /* 饬   ᭮ 䠩 */
         &indexFile,                   /* ᯨ᮪ 䠩  ᮢ */
         NULL,                         /* ᯨ᮪ ᥢ  䠩 */
         NULL                          /* ⥫쭠 ଠ    */
       ) )
  {
    fluSearcherFree( &searcher );
    fprintf( stderr, "訡 ஢ ᪠.\n%s\n", buf);
    exit( 1 );
  }

/* ⠥ १ */
  printf( "  '%s' 祭 ᫥騥 १  ࠬ 21...30:\n", QUERY);
  fluSearcherInitResult( &searcher, fsfShortForm); /*   ⮫쪮 URL */
  while( (result = fluSearcherNextResult( &searcher )) != NULL )
    printf( "%d: %s\n", result->number+1, result->wasError ? "???" : result->url);

/* ᢮   뢠 䠩 */
  fluSearcherFree( &searcher );

/* ! */
  exit( 0 );
}
