/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZTELNET_A
#define __ZTELNET_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __ZCOLL_A
#include "zcoll.h"
#endif

#ifndef __ZINET_A
#include "zinet.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************/
/*                                                                         */
/*  Protocol constants                                                     */
/*                                                                         */
/***************************************************************************/

#define ZTELNET_DEFAULT_PORT            23

/* Telnet commands */
/* End of file */
#define ZTELNET_COMMAND_EOF             236
#define ZTELNET_COMMAND_SUSP            237
#define ZTELNET_COMMAND_ABORT           238
#define ZTELNET_COMMAND_EOR             239
#define ZTELNET_COMMAND_SE              240
#define ZTELNET_COMMAND_NOP             241
#define ZTELNET_COMMAND_DM              242
#define ZTELNET_COMMAND_BREAK           243
#define ZTELNET_COMMAND_IP              244
#define ZTELNET_COMMAND_AO              245
#define ZTELNET_COMMAND_AYT             246
#define ZTELNET_COMMAND_EC              247
#define ZTELNET_COMMAND_EL              248
#define ZTELNET_COMMAND_GA              249
#define ZTELNET_COMMAND_SB              250  /* fa */
#define ZTELNET_COMMAND_WILL            251  /* fb */
#define ZTELNET_COMMAND_WONT            252  /* fc */
#define ZTELNET_COMMAND_DO              253  /* fd */
#define ZTELNET_COMMAND_DONT            254  /* fe */
#define ZTELNET_COMMAND_IAC             255  /* ff */

/* Telnet options */
#define ZTELNET_OPTION_BINARY           0       /* 8-bit data path */
#define ZTELNET_OPTION_ECHO             1       /* echo */
#define ZTELNET_OPTION_RCP              2       /* prepare to reconnect */
#define ZTELNET_OPTION_SGA              3       /* suppress go ahead */
#define ZTELNET_OPTION_NAMS             4       /* approximate message size */
#define ZTELNET_OPTION_STATUS           5       /* give status */
#define ZTELNET_OPTION_TM               6       /* timing mark */
#define ZTELNET_OPTION_RCTE             7       /* remote controlled transmission and echo */
#define ZTELNET_OPTION_NAOL             8       /* negotiate about output line width */
#define ZTELNET_OPTION_NAOP             9       /* negotiate about output page size */
#define ZTELNET_OPTION_NAOCRD           10      /* negotiate about CR disposition */
#define ZTELNET_OPTION_NAOHTS           11      /* negotiate about horizontal tabstops */
#define ZTELNET_OPTION_NAOHTD           12      /* negotiate about horizontal tab disposition */
#define ZTELNET_OPTION_NAOFFD           13      /* negotiate about formfeed disposition */
#define ZTELNET_OPTION_NAOVTS           14      /* negotiate about vertical tab stops */
#define ZTELNET_OPTION_NAOVTD           15      /* negotiate about vertical tab disposition */
#define ZTELNET_OPTION_NAOLFD           16      /* negotiate about output LF disposition */
#define ZTELNET_OPTION_XASCII           17      /* extended ascic character set */
#define ZTELNET_OPTION_LOGOUT           18      /* force logout */
#define ZTELNET_OPTION_BM               19      /* byte macro */
#define ZTELNET_OPTION_DET              20      /* data entry terminal */
#define ZTELNET_OPTION_SUPDUP           21      /* supdup protocol */
#define ZTELNET_OPTION_SUPDUPOUTPUT     22      /* supdup output */
#define ZTELNET_OPTION_SNDLOC           23      /* send location */
#define ZTELNET_OPTION_TTYPE            24      /* terminal type */
#define ZTELNET_OPTION_EOR              25      /* end or record */
#define ZTELNET_OPTION_TUID             26      /* TACACS user identification */
#define ZTELNET_OPTION_OUTMRK           27      /* output marking */
#define ZTELNET_OPTION_TTYLOC           28      /* terminal location number */
#define ZTELNET_OPTION_3270REGIME       29      /* 3270 regime */
#define ZTELNET_OPTION_X3PAD            30      /* X.3 PAD */
#define ZTELNET_OPTION_NAWS             31      /* window size */
#define ZTELNET_OPTION_TSPEED           32      /* terminal speed */
#define ZTELNET_OPTION_LFLOW            33      /* remote flow control */
#define ZTELNET_OPTION_LINEMODE         34      /* Linemode option */
#define ZTELNET_OPTION_XDISPLOC         35      /* X Display Location */
#define ZTELNET_OPTION_OLD_ENVIRON      36      /* Environment variables (old) */
#define ZTELNET_OPTION_AUTHENTICATION   37      /* Authenticate */
#define ZTELNET_OPTION_ENCRYPT          38      /* Encryption option */
#define ZTELNET_OPTION_NEW_ENVIRON      39      /* Environment variables (new) */
#define ZTELNET_OPTION_EXOPL            255     /* extended-options-list */

/* Telnet sub-option qualifiers */
#define ZTELNET_QUALIFIER_IS            0       /* option is... */
#define ZTELNET_QUALIFIER_SEND          1       /* send option */

/***************************************************************************/
/*                                                                         */
/*  Libzex's                                                               */
/*                                                                         */
/***************************************************************************/

#define ZTELNET_SUBOPTBUF_SIZE          256
#define ZTELNET_MAX_OPTION_COUNT        256

struct ztelnet_optcommand_t
{
  int value;
  Boolean enable;
  int myResp;
  unsigned char myWantFlag;
  unsigned char myStateFlag;
  int hisResp;
  unsigned char hisWantFlag;
  unsigned char hisStateFlag;
  Boolean agree;
  Boolean disagree;
};

extern struct ztelnet_optcommand_t ztTelnetOptionCommands[];

typedef void (*ztelnet_startup_t)( struct ztelnet_t * );
typedef void (*ztelnet_cmdhandler_t)( struct ztelnet_t *, int);
typedef Boolean (*ztelnet_opthandler_t)( struct ztelnet_t *, Boolean *, struct ztelnet_optcommand_t *, int);
typedef Boolean (*ztelnet_chanhandler_t)( struct ztelnet_t *, Boolean, struct ztelnet_optcommand_t *, int);
typedef Boolean (*ztelnet_subopthandler_t)( struct ztelnet_t * );
typedef void (*ztelnet_tracer_t)( struct ztelnet_t *, Boolean, int, int, const char *, int);
typedef void (*ztelnet_subtracer_t)( struct ztelnet_t *, Boolean, const unsigned char *, int);

typedef enum
{
  ZTELNET_STATE_DATA = 0,
  ZTELNET_STATE_IAC,
  ZTELNET_STATE_CR,
  ZTELNET_STATE_SB,
  ZTELNET_STATE_SE,
  ZTELNET_STATE_WILL = ZTELNET_COMMAND_WILL,
  ZTELNET_STATE_WONT = ZTELNET_COMMAND_WONT,
  ZTELNET_STATE_DO = ZTELNET_COMMAND_DO,
  ZTELNET_STATE_DONT = ZTELNET_COMMAND_DONT
} ztelnet_state_t;

struct ztelnet_option_t
{
  unsigned char resp[2];
  unsigned char flags;
  unsigned char unused;
};

struct ztelnet_t
{
/* Connection */
  struct in_addr ipAddr;
  unsigned short port;
  char *hostName;
  int timeout;

/* I/O */
  struct zsocket_t ts;
  struct zstrbuf_t input;
  struct zstrbuf_t output;

/* Options & suboptions */
  struct ztelnet_option_t options[ZTELNET_MAX_OPTION_COUNT];
  ztelnet_state_t state;
  unsigned char subopt[ZTELNET_SUBOPTBUF_SIZE];
  int suboptLength;

/* Handlers */
  ztelnet_startup_t startup;
  ztelnet_cmdhandler_t commandHandler;
  ztelnet_opthandler_t optionHandler;
  ztelnet_subopthandler_t suboptionHandler;
  ztelnet_chanhandler_t changedHandler;

/* Terminal */
  const char *termName;
  int rownum;
  int colnum;
  int ispeed;
  int ospeed;

/* Tracer */
  ztelnet_tracer_t tracer;
  void *tracerStream;
  unsigned int tracerFlags;
  ztelnet_subtracer_t subtracer;

/* Other data */
  unsigned int flags;
  void *userData;
};

#define ZTELNET_OPTRESP_DO_DONT         0
#define ZTELNET_OPTRESP_WILL_WONT       1

#define ZTELNET_OPTFLAG_STATE_WILL      0x01u
#define ZTELNET_OPTFLAG_WANT_WILL       0x02u
#define ZTELNET_OPTFLAG_STATE_DO        0x04u
#define ZTELNET_OPTFLAG_WANT_DO         0x08u
#define ZTELNET_OPTFLAG_NEGOTIATED      0x10u

#define ZTELNET_OPTCOMMAND_NUM(x)       (x - ZTELNET_COMMAND_WILL)

#define ZTELNET_FLAG_IBINARY            0x0001u
#define ZTELNET_FLAG_OBINARY            0x0002u
#define ZTELNET_FLAG_CRLF               0x0004u
#define ZTELNET_FLAG_NOOPTNG            0x0008u
#define ZTELNET_FLAG_LAST               0x0010u
#define ZTELNET_FLAG_VALID              0x000fu

#define ZTELNET_TRACER_RAWDATA_SENT     0x0001u
#define ZTELNET_TRACER_RAWDATA_RECEIVED 0x0002u
#define ZTELNET_TRACER_DATA_SENT        0x0004u
#define ZTELNET_TRACER_DATA_RECEIVED    0x0008u
#define ZTELNET_TRACER_OPTION_SENT      0x0010u
#define ZTELNET_TRACER_OPTION_RECEIVED  0x0020u
#define ZTELNET_TRACER_SUBOPT_SENT      0x0040u
#define ZTELNET_TRACER_SUBOPT_RECEIVED  0x0080u
#define ZTELNET_TRACER_COMMAND_SENT     0x0100u
#define ZTELNET_TRACER_COMMAND_RECEIVED 0x0200u
#define ZTELNET_TRACER_ALL              0x03ffu
#define ZTELNET_TRACER_ALL_OPTIONS      (ZTELNET_TRACER_OPTION_SENT | ZTELNET_TRACER_OPTION_RECEIVED | ZTELNET_TRACER_SUBOPT_SENT | ZTELNET_TRACER_SUBOPT_RECEIVED | ZTELNET_TRACER_COMMAND_SENT | ZTELNET_TRACER_COMMAND_RECEIVED)

Boolean zTelnetInit( struct zcontext_t *cnt, struct ztelnet_t *tn, int timeout, unsigned int flags);
void zTelnetFree( struct ztelnet_t *tn );
Boolean zTelnetSetTerminal( struct ztelnet_t *tn, const char *termName,
    int rownum, int colnum, int ispeed, int ospeed);

void zTelnetSetTracer( struct ztelnet_t *tn, ztelnet_tracer_t tracer,
    ztelnet_subtracer_t subtracer, void *stream, unsigned int flags);
void zTelnetSetHandlers( struct ztelnet_t *tn, ztelnet_startup_t startup,
    ztelnet_cmdhandler_t commandHandler, ztelnet_opthandler_t optionHandler,
    ztelnet_subopthandler_t suboptionHandler, ztelnet_chanhandler_t changedHandler);

Boolean zTelnetMakeConnection( struct ztelnet_t *tn, struct in_addr *ipAddr, unsigned short port);
Boolean zTelnetOpenConnection( struct ztelnet_t *tn, const char *hostName, unsigned short port);
void zTelnetCloseConnection( struct ztelnet_t *tn );

Boolean zTelnetSendOption( struct ztelnet_t *tn, int command, int option, Boolean reply);
Boolean zTelnetReceiveOption( struct ztelnet_t *tn, int command, int option);
Boolean zTelnetReceiveSuboption( struct ztelnet_t *tn );
Boolean zTelnetChangeOption( struct ztelnet_t *tn, Boolean isAnswer, struct ztelnet_optcommand_t *cmd, int option);
Boolean zTelnetOptionHandler( struct ztelnet_t *tn, Boolean *preply, struct ztelnet_optcommand_t *cmd, int option);
Boolean zTelnetSendWindowSize( struct ztelnet_t *tn );
void zTelnetStartup( struct ztelnet_t *tn );

Boolean zTelnetProcessOutput( struct ztelnet_t *tn, const char *buf, int length);
Boolean zTelnetProcessInput( struct ztelnet_t *tn, const char *buf, int length);

int zTelnetRead( struct ztelnet_t *tn, char *buf, int size, Boolean block);
Boolean zTelnetWrite( struct ztelnet_t *tn, const char *buf, int length, Boolean block);
Boolean zTelnetSheduler( struct ztelnet_t *tn, Boolean block);

typedef int (*ztelnet_test_t)( char *, int, Boolean, void *);
int zTelnetGets( struct ztelnet_t *tn, char *buf, int size, Boolean block);
Boolean zTelnetPuts( struct ztelnet_t *tn, const char *string);
int zTelnetWaitfor( struct ztelnet_t *tn, ztelnet_test_t test, void *data);

struct ztelnet_trname_t
{
  const char *shrt;
  const char *full;
};

extern const struct ztelnet_trname_t commandList[];
extern const struct ztelnet_trname_t optionList[];

void zTelnetTracer( struct ztelnet_t *tn, Boolean sent, int command,
    int option, const char *buf, int length);
void zTelnetSuboptionTracer( struct ztelnet_t *tn, Boolean sent,
    const unsigned char *buf, int length);

#ifdef __cplusplus
}
#endif

#endif
