/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZINET_A
#define __ZINET_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PINET_A
#include "_pinet.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Types & defines */
struct zsocket_t
{
  struct zcontext_t *context;
#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
  SOCKET sock;
#else
  int sock;
#endif
  unsigned int flags;
};

/* Errors */
typedef enum _zinetarea_t
{
  ZINETAREA_NONE = 0,
#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
  ZINETAREA_STARTUP,
#endif
  ZINETAREA_SOCKET,
  ZINETAREA_CONNECT,
  ZINETAREA_BIND,
  ZINETAREA_SETSOCKOPT,
  ZINETAREA_IOCTLSOCKET,
  ZINETAREA_SELECT,
  ZINETAREA_RECV,
  ZINETAREA_SEND,
  ZINETAREA_GETHOSTBYNAME,
  ZINETAREA_GETHOSTBYADDR,
  ZINETAREA_LAST
} zinetarea_t;

enum
{
  ZINETERR_NONE = 0,
  ZINETERR_UNKNOWN = -1,
  ZINETERR_TIMEOUT = -2,
  ZINETERR_CONREFUSED = -3,
  ZINETERR_CONRESET = -4,
  ZINETERR_HOSTNOTFOUND = -5,
  ZINETERR_LAST = -6
};

const char *zInetErrorArea( zinetarea_t area );
const char *zInetErrorString( zinetarea_t area, int errorCode);
int zInetErrorClass( int errorCode );

#ifndef EALLPORTSINUSE
#define EALLPORTSINUSE               22220
#endif

#ifndef EZEROREAD
#define EZEROREAD                    22221
#endif

#if !defined( HAVE_WINSOCK2_H ) && !defined( HAVE_WINSOCK_H )
#ifndef EHOSTNOTFOUND
#define EHOSTNOTFOUND                22222
#endif
#ifndef ETRYAGAIN
#define ETRYAGAIN                    22223
#endif
#ifndef ENORECOVERY
#define ENORECOVERY                  22224
#endif
#ifndef ENODATA
#define ENODATA                      22225
#endif
#endif

/* Startup & closeup */
Boolean zInetStartup( struct zcontext_t *cnt );
void zInetCloseup( struct zcontext_t *cnt );

/* Socket */
#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
#define ZISBADSOCKET(x)              (x == INVALID_SOCKET)
#else
#define ZISBADSOCKET(x)              (x < 0)
#endif

#define ZINET_SOCKOPT_OPEN           0x0001u
#define ZINET_SOCKOPT_CONNECTED      0x0002u
#define ZINET_SOCKOPT_AUTOCLOSE      0x0008u
#define ZINET_SOCKOPT_OOBINLINE      0x0010u
#define ZINET_SOCKOPT_NONBLOCKING    0x0020u
#define ZINET_SOCKOPT_WOULDBLOCK     0x0100u
#define ZINET_SOCKOPT_ZEROREAD       0x0200u

void zInetSocketInit( struct zcontext_t *cnt, struct zsocket_t *ps, Boolean autoClose);
Boolean zInetSocketOpen( struct zsocket_t *ps );
void zInetSocketClose( struct zsocket_t *ps );

Boolean zInetMakeConnection( struct zsocket_t *ps, struct in_addr *ipAddr, unsigned short port);
Boolean zInetSocketControl( struct zsocket_t *ps, unsigned int control, Boolean install);

Boolean zInetBind( struct zsocket_t *ps, struct in_addr *ipAddr, unsigned short port);
Boolean zInetBindPort( struct zsocket_t *ps, unsigned short *pport, unsigned short bport);

/* I/O */
#define ZINET_MODE_READ              0x0001u
#define ZINET_MODE_EXREAD            0x0002u
#define ZINET_MODE_WRITE             0x0004u
#define ZINET_MODE_INTR              0x0008u

int zInetAtMark( struct zsocket_t *ps );
Boolean zInetCheckData( struct zsocket_t *ps, unsigned int *pmode, int timeout);

int zInetRead( struct zsocket_t *ps, char *buf, int size, int timeout);
int zInetWrite( struct zsocket_t *ps, char *buf, int length, int timeout);

/* Resolving */
Boolean zInetStringToAddr( struct in_addr *ipAddr, const char *string);
char *zInetAddrToString( struct in_addr *ipAddr, char *string);

Boolean zInetHostAddr( struct zcontext_t *cnt, struct in_addr *ipAddr, const char *hostName);

#ifdef __cplusplus
}
#endif

#endif
