/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZCGI_A
#define __ZCGI_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PSTDIO_A
#include "_pstdio.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* CGI structures */
enum
{
  ZCGI_ENV_QUERY_STRING,
  ZCGI_ENV_REQUEST_METHOD,
  ZCGI_ENV_CONTENT_LENGTH,
#ifdef RUSSIAN_SUPPORT
  ZCGI_ENV_LOCAL_CHARSET,
  ZCGI_ENV_REMOTE_CHARSET,
#endif
#ifdef _ZCGI_AUTH_TYPE
  ZCGI_ENV_AUTH_TYPE,
#endif
#ifdef _ZCGI_CONTENT_TYPE
  ZCGI_ENV_CONTENT_TYPE,
#endif
#ifdef _ZCGI_GATEWAY_INTERFACE
  ZCGI_ENV_GATEWAY_INTERFACE,
#endif
#ifdef _ZCGI_HTTP_ACCEPT
  ZCGI_ENV_HTTP_ACCEPT,
#endif
#ifdef _ZCGI_HTTP_REFERER
  ZCGI_ENV_HTTP_REFERER,
#endif
#ifdef _ZCGI_HTTP_USER_AGENT
  ZCGI_ENV_HTTP_USER_AGENT,
#endif
#ifdef _ZCGI_PATH_INFO
  ZCGI_ENV_PATH_INFO,
#endif
#ifdef _ZCGI_PATH_TRANSLATED
  ZCGI_ENV_PATH_TRANSLATED,
#endif
#ifdef _ZCGI_REMOTE_ADDR
  ZCGI_ENV_REMOTE_ADDR,
#endif
#ifdef _ZCGI_REMOTE_HOST
  ZCGI_ENV_REMOTE_HOST,
#endif
#ifdef _ZCGI_REMOTE_IDENT
  ZCGI_ENV_REMOTE_IDENT,
#endif
#ifdef _ZCGI_REMOTE_USER
  ZCGI_ENV_REMOTE_USER,
#endif
#ifdef _ZCGI_SCRIPT_FILENAME
  ZCGI_ENV_SCRIPT_FILENAME,
#endif
#ifdef _ZCGI_SCRIPT_NAME
  ZCGI_ENV_SCRIPT_NAME,
#endif
#ifdef _ZCGI_SERVER_NAME
  ZCGI_ENV_SERVER_NAME,
#endif
#ifdef _ZCGI_SERVER_PORT
  ZCGI_ENV_SERVER_PORT,
#endif
#ifdef _ZCGI_SERVER_PROTOCOL
  ZCGI_ENV_SERVER_PROTOCOL,
#endif
#ifdef _ZCGI_SERVER_SOFTWARE
  ZCGI_ENV_SERVER_SOFTWARE,
#endif
  ZCGI_ENV_LAST
};

#define ZCGI_MAX_TEMPLATE_LEVEL     16
#if SIZEOF_INT < 4
#define ZCGI_MAX_POST_SIZE          (16*1024)
#else
#define ZCGI_MAX_POST_SIZE          (200*1024)
#endif

struct zcginput_t
{
  char *name;
  char *value;
  int valueLength;
  int rmethod;
};

struct zcgidata_t
{
  struct zcontext_t *context;
  unsigned int flags;

/* CGI query */
  const char *env[ZCGI_ENV_LAST];
  char *getInputString;
  char *postInputString;
  int contentLength;
  int requestMethod;
  struct zcginput_t *inputList;
  int inputCount;

/* User agent */
  int userAgentType;
  int userAgentVersion;

/* HTML */
  void (*headAddition)( struct zcgidata_t *cd );
  const char *pageBackgroundImage;
  zint_t pageBackgroundColor;
  zint_t pageTextColor;
  zint_t pageLinkColor;
  zint_t pageVLinkColor;
  zint_t pageALinkColor;
  const char *bodyTagAddition;

/* Templates */
  int ifs[ZCGI_MAX_TEMPLATE_LEVEL];
  int ifLevel;
  struct zcgi_tplvalue_t *forValue;
  const char *forStart;

/* Application's */
  unsigned int urlFlags;

/* Other */
  void *userData;
  void *userData2;
  void *userData3;
  void *userData4;
};

struct zcgi_tplvalue_t
{
  const char *name;
  int length;
  Boolean hasParam;
  void (*writeValue)( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
  zint_t (*getValue)( struct zcgidata_t *cd, const char *param, const char *modif, void *info);
  Boolean (*nextValue)( struct zcgidata_t *cd, void *info, Boolean nextStep);
};

#define ZCGI_FLAG_ENV               0x0001u
#define ZCGI_FLAG_INPUT             0x0002u
#define ZCGI_FLAG_CHARSET           0x0004u
#define ZCGI_FLAG_RECODE            0x0008u
#define ZCGI_FLAG_USER_AGENT        0x0010u
#define ZCGI_FLAG_START_DOCUMENT    0x0040u
#define ZCGI_FLAG_END_DOCUMENT      0x0080u
#define ZCGI_FLAG_DEFAULT_CHARSET   0x0100u
#define ZCGI_FLAG_RUSSIAN_APACHE    0x0200u

void zcgiInitData( struct zcontext_t *cnt, struct zcgidata_t *cd);
void zcgiFreeData( struct zcgidata_t *cd );

/* CGI Environment */
void zcgiGetEnvironment( struct zcgidata_t *cd );
const char *zcgiGetenv( struct zcgidata_t *cd, const char *name);

/* Request method */
#define ZCGI_RMETHOD_UNKNOWN        0
#define ZCGI_RMETHOD_GET            1
#define ZCGI_RMETHOD_POST           2

int zcgiGetRequestMethodByName( const char *requestMethod );
const char *zcgiGetRequestMethodByType( int type );

/* CGI Input */
Boolean zcgiTranslateInput( struct zcgidata_t *cd, char *inputString, int rmethod);
Boolean zcgiGetInput( struct zcgidata_t *cd );

Boolean zcgiSearchInput( struct zcgidata_t *cd, const char *name, int *pindex);
struct zcginput_t *zcgiFindInput( struct zcgidata_t *cd, const char *name, int *pcount);
Boolean zcgiFindInputValue( struct zcgidata_t *cd, const char *name, const char *value);
Boolean zcgiFindInputValueEx( struct zcginput_t *id, int count, const char *value);

/* User agent */
enum
{
  agtUnknown = 0,
  agtNavigator,
  agtExplorer,
  agtMozillaCompatible,
  agtLynx,
  agtDosLynx
};

void zcgiGetUserAgent( struct zcgidata_t *cd );

/* Russian support */
#ifdef RUSSIAN_SUPPORT
void zcgiCharsetSetup( struct zcgidata_t *cd, Boolean full);
void zcgiUnsetStrictRecoding( struct zcgidata_t *cd );
const char *zcgiRemoteCharsetName( struct zcgidata_t *cd );
const char *zcgiRemoteStrictCharsetName( struct zcgidata_t *cd );
void zcgiRecodeInput( struct zcgidata_t *cd );
#endif

/* I/O */
Boolean zcgiWriteData( struct zcgidata_t *cd, unsigned int flags, const char *data, int length);
Boolean zcgiWritef( struct zcgidata_t *cd, const char *fmt, ...);

/* Files */
Boolean zcgiWriteFile( struct zcgidata_t *cd, const char *fileName, const char *fileAlias);
int zcgiWriteFileBlock( struct zcgidata_t *cd, const char *fileName,
    const char *fileAlias, const char *blockName);

/* HTML */
void zcgiStartDocument( struct zcgidata_t *cd, const char *title);
void zcgiEndDocument( struct zcgidata_t *cd );

#define ZCGI_COLOR_NONE             __ZINT(-1)
#define _ZCGI_COLOR_PRINT_FORMAT    "%06.6" _ZINT_FORMAT "X"
#define ZCGI_COLOR_PRINT_FORMAT     "#" _ZCGI_COLOR_PRINT_FORMAT
zint_t zcgiColorNumber( const char *name );

void zcgiWriteError( struct zcgidata_t *cd );

struct zcgi_tplvalue_t *zcgiFindTemplateValue( struct zcgi_tplvalue_t *table,
    const char *name);
void zcgiWriteTemplateString( struct zcgidata_t *cd,
    struct zcgi_tplvalue_t *table, const char *string, void *info);

void zcgiWriteCheckboxHeader( struct zcgidata_t *cd, const char *header, zint_t color, Boolean spec);
void zcgiWriteCheckboxEnd( struct zcgidata_t *cd, Boolean spec);

void zcgiWriteSubstring( struct zcgidata_t *cd, const char *string,
    const char *substring, const char *substringEnd, zint_t bgcolor, zint_t subcolor);
void zcgiWriteEmailLink( struct zcgidata_t *cd, const char *text, const char *email,
    const char *subject, const char *body, Boolean checkBrowser);
Boolean zcgiWriteResultPages( struct zcgidata_t *cd, zint_t totalPages,
    zint_t curPage, zint_t pagesPerBlock,
    const char *ref, const char *paramName, const char *nextText,
    const char *prevText, Boolean addon);

#ifdef __cplusplus
}
#endif

#endif
