/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zchars.h"
#include "zurl.h"

/***************************************************************************/
/*                                                                         */
/*  Special reference with recoding                                        */
/*                                                                         */
/***************************************************************************/

int zurlAddString( char *ref, int size, const char *string,
    const char *tranTable, unsigned int flags)
{
  Boolean hasTable = (Boolean) (tranTable != NULL);
  int initialSize = size;
  register char *ptr = ref;
  register int c;

  if( string == NULL )
  {
    *ptr = '\0';
    return 0;
  }

  for( ; (c = *(unsigned char *) string) != '\0'; string++)
  {
    if( c == ' ' )
    {
      if( size <= 1 ){ size = 0; break; }
      *ptr ++ = '+';
      size--;
      continue;
    }

    if( hasTable && (c & 0x80) != 0 ) c = tranTable[ (c & 0x7f) ] & 0xff;

    if( _isAlnum( c ) ||
	(!zCheckFlags( flags, zufStrict) && (c & 0x80) != 0) ||
        (!zCheckFlags( flags, zufAll) && (c & 0x80) == 0 &&
	 (!_isURLSpecial( c ) ||
	 (c == '@' && zCheckFlags( flags, zufAtPreserve)))) )
    {
      if( size <= 1 ){ size = 0; break; }
      *ptr ++ = (char) c;
      size--;
    }
    else
    {
      if( size <= 3 ){ size = 0; break; }
      *ptr ++ = '%';
      *ptr ++ = zUpperHex( c >> 4 );
      *ptr ++ = zUpperHex( c );
      size -= 3;
    }
  }

  if( zCheckFlags( flags, zufQuestionMark) )
    if( size <= 1 )
      size = 0;
    else
    {
      *ptr ++ = '?';
      size--;
    }

  *ptr = '\0';
  return size > 0 ? initialSize - size : -1;
}

Boolean zurlAddReference( char *ref, int size, const char *name,
    const char *value, const char *tranTable, unsigned int flags)
{
  int refLength = strlen( ref );
  char *ptr, *s;
  int l;

  if( size - refLength <= 2 ) return False;

  ptr = &ref[refLength];
  size -= refLength;

  if( (s = strchr( ref, '?')) == NULL )
  {
    *ptr ++ = '?';
    size--;
  }
  else if( s[1] != '\0' )
  {
    *ptr ++ = '&';
    size--;
  }

  if( (l = zurlAddString( ptr, size, name, tranTable, flags)) < 0 ) return False;
  size -= l;
  ptr += l;

  if( size <= 1 ) return False;
  *ptr ++ = '=';
  size--;

  if( (l = zurlAddString( ptr, size, value, tranTable, flags)) < 0 ) return False;

  return True;
}
