/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zchars.h"

#include "zurl.h"

/***************************************************************************/
/*                                                                         */
/*  Decode                                                                 */
/*                                                                         */
/***************************************************************************/

int zurlFromXDigit( register int number )
{
  if( number >= '0' && number <= '9' )
    return number - '0';
  else if( number >= 'A' && number <= 'F' )
    return number - 'A' + 10;
  else if( number >= 'a' && number <= 'f' )
    return number - 'a' + 10;
  else
    return 0;
}

int zurlDecodeString( char *string )
{
  register char *dest, *src;

  for( dest = src = string; *src != '\0'; src++, dest++)
  {
    int c = *src;

    if( c == '+' )
      c = ' ';
    else if( c == '%' )
      if( isXDigit( src[1] ) )
      {
        src++;
        c = zurlFromXDigit( *src );
        if( isXDigit( src[1] ) )
	{
          src++;
	  c <<= 4;
          c += zurlFromXDigit( *src );
	}
      }

    *dest = (char) c;
  }

  *dest = '\0';
  return (int) (dest-string);
}
