/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zcoll.h"
#include "ztelnet.h"

/***************************************************************************/
/*                                                                         */
/*  String input & output                                                  */
/*                                                                         */
/***************************************************************************/

int zTelnetGets( struct ztelnet_t *tn, char *buf, int size, Boolean block)
{
  int toRead;
  char *ptr;

  if( zStringBufferEmpty( &tn->input ) )
    if( !zTelnetSheduler( tn, block) ) return -1;

  if( (toRead = ZMIN( tn->input.length, size-1)) <= 0 ) return 0;

  if( (ptr = memchr( zStringBufferItself( &tn->input ), '\n', toRead)) != NULL )
    toRead = (int) (ptr - zStringBufferItself( &tn->input )) + 1;

  memcpy( buf, zStringBufferItself( &tn->input ), toRead);
  if( !zStringBufferShift( &tn->input, 0, -toRead) )
  {
    tn->ts.context->inetError = ZINETERR_UNKNOWN;
    return -1;
  }

  {
    register int i;
    for( i = 0; i < toRead; i++) if( buf[i] == '\0' ) buf[i] = ' ';
  }
  buf[toRead] ='\0';

  return toRead;
}

Boolean zTelnetPuts( struct ztelnet_t *tn, const char *string)
{
  return zTelnetWrite( tn, string, strlen( string ), False);
}

int zTelnetWaitfor( struct ztelnet_t *tn, ztelnet_test_t test, void *data)
{
  char buf[4*1024];
  int shift, retval;
  Boolean full;

  for( shift = 0; ; )
  {
    if( (retval = zTelnetGets( tn, &buf[shift], sizeof( buf ) - shift, True)) < 0 )
      return retval;
    shift += retval;
    full = (Boolean) (buf[shift-1] == '\n' || shift >= (sizeof( buf ) - 1));
    if( (retval = test( buf, shift, full, data)) != 0 ) return retval;
    if( full ) shift = 0;
  }
}
