/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"

#include "zinet.h"

int zInetErrorClass( int errorCode )
{
  switch( errorCode )
  {
#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
    case WSAETIMEDOUT:
#else
    case ETIMEDOUT:
#endif
      return ZINETERR_TIMEOUT;

#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
    case WSAECONNRESET:
#else
    case ECONNRESET:
#endif
      return ZINETERR_CONRESET;

#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
    case WSAECONNREFUSED:
#else
    case ECONNREFUSED:
#endif
      return ZINETERR_CONREFUSED;

#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
    case WSAHOST_NOT_FOUND:
    case WSANO_DATA:
#else
    case EHOSTNOTFOUND:
    case ENODATA:
#endif
      return ZINETERR_HOSTNOTFOUND;
  }

  return ZINETERR_UNKNOWN;
}
