/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"

#include "zinet.h"

const char *zInetErrorArea( zinetarea_t area )
{
  switch( area )
  {
    case ZINETAREA_NONE:          return "none";
    case ZINETAREA_SOCKET:        return "socket()";
    case ZINETAREA_CONNECT:       return "connect()";
    case ZINETAREA_BIND:          return "bind()";
    case ZINETAREA_SETSOCKOPT:    return "setsockopt()";
#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
    case ZINETAREA_IOCTLSOCKET:   return "ioctlsocket()";
#else
    case ZINETAREA_IOCTLSOCKET:   return "ioctl()";
#endif
    case ZINETAREA_SELECT:        return "select()";
    case ZINETAREA_RECV:          return "recv()";
    case ZINETAREA_SEND:          return "send()";
    case ZINETAREA_GETHOSTBYNAME: return "gethostbyname()";
  }

  return "???";
}
