/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#if !defined( HAVE_INET_ATON )
#include "_pstring.h" /* <string.h> */
#endif

#include "zcontext.h"
#include "zinet.h"

#if !defined( HAVE_WINSOCK2_H ) && !defined( HAVE_WINSOCK_H )
#include <netdb.h>
#endif

/***************************************************************************/
/*                                                                         */
/*  Simple address resolver                                                */
/*                                                                         */
/***************************************************************************/

Boolean zInetHostAddr( struct zcontext_t *cnt, struct in_addr *ipAddr, const char *hostName)
{
  struct hostent *host;

  if( zInetStringToAddr( ipAddr, hostName) ) return True;

  if( (host = gethostbyname( hostName )) == NULL )
  {
    cnt->inetErrorArea = ZINETAREA_GETHOSTBYNAME;
#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
    cnt->inetError = WSAGetLastError();
#else
    switch( h_errno )
    {
      case HOST_NOT_FOUND: cnt->inetError = EHOSTNOTFOUND; break;
      case NO_DATA:        cnt->inetError = ENODATA;       break;
      case TRY_AGAIN:      cnt->inetError = ETRYAGAIN;     break;
      default:
      case NO_RECOVERY:    cnt->inetError = ENORECOVERY;   break;
    }
#endif
    return False;
  }

#ifdef h_addr
  memcpy( ipAddr, host->h_addr_list[0], ZMIN( host->h_length, sizeof( struct in_addr )));
#else
  memcpy( ipAddr, host->h_addr, ZMIN( host->h_length, sizeof( struct in_addr )));
#endif

  return True;
}
