/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#if !defined( HAVE_INET_ATON )
#include "_pstring.h" /* <string.h> */
#endif

#include "zinet.h"

#if !defined( HAVE_WINSOCK2_H ) && !defined( HAVE_WINSOCK_H )
#include <netdb.h>
#endif

/***************************************************************************/
/*                                                                         */
/*  Simple address converting                                              */
/*                                                                         */
/***************************************************************************/

Boolean zInetStringToAddr( struct in_addr *ipAddr, const char *string)
{
#if defined( HAVE_INET_ATON )
  return (Boolean) inet_aton( string, ipAddr);
#else
  unsigned long val = inet_addr( string );

  if( val == INADDR_NONE ) return False;
  memcpy( ipAddr, &val, ZMIN( sizeof(struct in_addr), sizeof(val)));

  return True;
#endif
}

char *zInetAddrToString( struct in_addr *ipAddr, char *string)
{
  char *s = inet_ntoa( *ipAddr );

  if( string != NULL )
  {
    strncpy( string, s, 15);
    string[15] = '\0';
    return string;
  }

  return s;
}
