/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zinet.h"
#ifdef DEBUG
#include "zstdio.h"
#endif

Boolean zInetBind( struct zsocket_t *ps, struct in_addr *ipAddr, unsigned short port)
{
  struct sockaddr_in sockAddr;

#ifdef DEBUG
  if( ps->context->inetDebug )
  {
    char buf[30];
    zfprintf( NULL, NULL, "zInetBind: ");
    if( !zCheckFlags( ps->flags, ZINET_SOCKOPT_OPEN) )
      zfprintf( NULL, NULL, "socket isnt't open yet, ");
    else
      zfprintf( NULL, NULL, "socket = %d, ", ps->sock);
    zfprintf( NULL, NULL, "for address '%s', port %hu\n", zInetAddrToString( ipAddr, buf), port);
  }
#endif

  if( !zCheckFlags( ps->flags, ZINET_SOCKOPT_OPEN) )
  {
    if( !zInetSocketOpen( ps ) ) return False;
    zSetFlags( ps->flags, ZINET_SOCKOPT_AUTOCLOSE);
  }

  sockAddr.sin_family = AF_INET;
  sockAddr.sin_port = htons( port );
  memcpy( &sockAddr.sin_addr, ipAddr, sizeof( sockAddr.sin_addr ));

  if( bind( ps->sock, (struct sockaddr *) &sockAddr, sizeof( sockAddr)) != 0 )
  {
#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
    ps->context->inetError = WSAGetLastError();
#else
    ps->context->inetError = errno;
#endif
    ps->context->inetErrorArea = ZINETAREA_BIND;

    if( zCheckFlags( ps->flags, ZINET_SOCKOPT_AUTOCLOSE) ) zInetSocketClose( ps );

#ifdef DEBUG
    if( ps->context->inetDebug ) zfprintf( NULL, NULL, "      unsuccessful 'bind()', error code %d\n", ps->context->inetError);
#endif
    return False;
  }

#ifdef DEBUG
  if( ps->context->inetDebug ) zfprintf( NULL, NULL, "      bound successfully, socket = %d\n", ps->sock);
#endif
  return True;
}

Boolean zInetBindPort( struct zsocket_t *ps, unsigned short *pport, unsigned short bport)
{
  struct in_addr ipAddr;
  Boolean success = True;

  /* XXX: htonl() ... */
  ipAddr.s_addr = INADDR_ANY;

#ifdef DEBUG
  if( ps->context->inetDebug )
  {
    zfprintf( NULL, NULL, "zInetBindPort: ");
    if( !zCheckFlags( ps->flags, ZINET_SOCKOPT_OPEN) )
      zfprintf( NULL, NULL, "socket isnt't open yet, ");
    else
      zfprintf( NULL, NULL, "socket = %d, ", ps->sock);
    if( pport == NULL )
      zfprintf( NULL, NULL, "for port %hu\n", bport);
    else
      zfprintf( NULL, NULL, "for port range %hu - %hu\n", *pport, bport);
  }
#endif

  if( pport == NULL ) return zInetBind( ps, &ipAddr, bport);

  while( *pport != bport )
  {
    if( zInetBind( ps, &ipAddr, *pport) ) break;
#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
    if( ps->context->inetError == WSAEADDRINUSE )
#else
    if( ps->context->inetError == EADDRINUSE )
#endif
    {
      if( *pport < bport ) (*pport)++; else (*pport)--;
      continue;
    }
    success = False;
    break;
  }

  if( success && *pport == bport )
  {
    if( !(success = zInetBind( ps, &ipAddr, bport)) )
#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
      if( ps->context->inetError == WSAEADDRINUSE )
#else
      if( ps->context->inetError == EADDRINUSE )
#endif
        ps->context->inetError = EALLPORTSINUSE;
  }

#ifdef DEBUG
  if( ps->context->inetDebug )
    if( success )
      zfprintf( NULL, NULL, "      bound successfully, port = %hu\n", *pport);
    else
      zfprintf( NULL, NULL, "      unsuccessful 'bind()', error code %d\n", ps->context->inetError);
#endif
  return success;
}
