/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include <stdlib.h>

#include "zcontext.h"
#include "zinet.h"

/***************************************************************************/
/*                                                                         */
/*  Startup & closeup                                                      */
/*                                                                         */
/***************************************************************************/

static void zInetExit( struct zcontext_t *cnt )
{
  if( !cnt->inetStarted ) return;
  cnt->inetErrorArea = ZINETAREA_NONE;

#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
  WSACleanup();
#endif

  cnt->inetStarted = False;
}

Boolean zInetStartup( struct zcontext_t *cnt )
{
  Boolean success = True;

  if( cnt->inetStarted ) return True;
  cnt->inetErrorArea = ZINETAREA_NONE;

#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
  {
    WORD wVersionRequested;
    WSADATA wsaData;

#if defined( HAVE_WINSOCK2_H )
    wVersionRequested = MAKEWORD( 2, 0);
#else
    wVersionRequested = MAKEWORD( 1, 1);
#endif

    if( (cnt->inetError = WSAStartup( wVersionRequested, &wsaData)) != 0 )
      success = False;

    if( success && (LOBYTE( wsaData.wVersion ) < 1 ||
          (LOBYTE( wsaData.wVersion ) == 1 && HIBYTE( wsaData.wVersion ) < 1)) )
    {
      cnt->inetError = WSAVERNOTSUPPORTED;
      WSACleanup();
      success = False;
    }

    if( !success ) cnt->inetErrorArea = ZINETAREA_STARTUP;
  }
#endif

  if( success )
  {
#if defined( HAVE_WINSOCK2_H ) || defined( HAVE_WINSOCK_H )
/*  atexit( zInetExit ); */
#endif
    cnt->inetStarted = True;
  }

  return True;
}


void zInetCloseup( struct zcontext_t *cnt )
{
  zInetExit( cnt );
}
