/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zstdio.h"
#include "zcgi.h"

static void zcgiWriteResultPagesRef( struct zcgidata_t *cd,
    const char *ref, const char *paramName,
    int c, zint_t num, const char *text, Boolean addon)
{
  char line[256];

  if( text == NULL )
  {
    zsprintf( line, sizeof( line ), "%" _ZINT_FORMAT "d", num + 1);
    text = line;
  }

  if( ref == NULL )
    zcgiWritef( cd, "%t\n", text);
  else
    zcgiWritef( cd, "%{"
        "<a href=\"%~s%[%c%v=%" _ZINT_FORMAT "d%]\">%t</a>\n", 
      ref, (num > 0), c, paramName, num + (addon ? 1 : 0), text);
}

Boolean zcgiWriteResultPages( struct zcgidata_t *cd, zint_t totalPages,
    zint_t curPage, zint_t pagesPerBlock,
    const char *ref, const char *paramName, const char *nextText,
    const char *prevText, Boolean addon)
{
  zint_t startPage, endPage, i;
  zint_t curBlock, totalBlocks;
  int c;

  if( totalPages <= 1 ) return False;
  c = (strchr( ref, '?') == NULL) ? '?' : '&';

  totalBlocks = totalPages / pagesPerBlock + (totalPages % pagesPerBlock > 0 ? 1 : 0);
  curBlock = curPage / pagesPerBlock;

  if( curBlock > 0 )
    zcgiWriteResultPagesRef( cd, ref, paramName, c, curBlock * pagesPerBlock,
      prevText == NULL ? "<<-" : prevText, addon);

  startPage = curBlock * pagesPerBlock;
  endPage = (curBlock + 1) * pagesPerBlock;
  if( endPage > totalPages ) endPage = totalPages;

  for( i = startPage; i < endPage; i++)
    zcgiWriteResultPagesRef( cd, (i == curPage) ? NULL : ref, paramName, c, i, NULL, addon);

  if( curBlock < totalBlocks-1 )
    zcgiWriteResultPagesRef( cd, ref, paramName, c, (curBlock + 1) * pagesPerBlock,
      nextText == NULL ? "->>" : nextText, addon);

  return True;
}
