/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zcgi.h"

void zcgiWriteEmailLink( struct zcgidata_t *cd, const char *text, const char *email,
    const char *subject, const char *body, Boolean checkBrowser)
{
  zcgiWritef( cd, "<a href=\"mailto:%V", email);

  zcgiGetUserAgent( cd );

  if( !checkBrowser || (cd->userAgentVersion >= 400 &&
       (cd->userAgentType == agtNavigator || cd->userAgentType == agtExplorer)) ||
      (cd->userAgentVersion >= 280 && cd->userAgentType == agtLynx) )
  {
    if( subject != NULL )
      zcgiWritef( cd, "?SUBJECT=%V", subject);
    if( body != NULL )
      zcgiWritef( cd, subject == NULL ? "?BODY=%V" : "&BODY=%V", body);
  }

  zcgiWritef( cd, "\">%t</a>", text);
}
