/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zchars.h"
#include "zcgi.h"

void zcgiWriteSubstring( struct zcgidata_t *cd, const char *string,
    const char *substring, const char *substringEnd, zint_t bgcolor, zint_t subcolor)
{
  const char *s;
  Boolean started = False;

  zcgiWritef( cd, "%{" 
      "<table width=\"100%\" border=0 cols=1>\n<tr><td align=\"left\""
      "%[ bgcolor=\"" ZCGI_COLOR_PRINT_FORMAT "\"%]><pre><nobr>%.*c<blink>"
      "%[<font color=\"" ZCGI_COLOR_PRINT_FORMAT "\">%]v%[</font>%]"
      "</blink></nobr>\n<nobr><b>",
    (bgcolor != ZCGI_COLOR_NONE), bgcolor, 
    (int) (substringEnd - string), ' ',
    (subcolor != ZCGI_COLOR_NONE), subcolor, (subcolor != ZCGI_COLOR_NONE));

  for( s = string; *s != '\0'; s++)
  {
    if( s == substring )
    {
      started = True;
      zcgiWritef( cd, "%{"
          "%[<font color=\"" ZCGI_COLOR_PRINT_FORMAT "\">%]%C", 
        (subcolor != ZCGI_COLOR_NONE), subcolor, *s);
    }
    else if( isSpace( *s ) )
      zcgiWritef( cd, " ");
    else
      zcgiWritef( cd, "%C", *s);

    if( s == substringEnd && started )
    {
      started = False;
      if( subcolor != ZCGI_COLOR_NONE )
        zcgiWritef( cd, "%~s", "</font>");
    }
  }

  zcgiWritef( cd, "%{"
      "%[</font>%]</b></nobr>\n"
      "<nobr>%.*c<blink>%[<font color=\"" ZCGI_COLOR_PRINT_FORMAT "\">%]^%[</font>%]</blink></nobr></pre>\n"
      "</td></tr></table>\n",
    (started && subcolor != ZCGI_COLOR_NONE),
    (int) (substringEnd - string), ' ',
    (subcolor != ZCGI_COLOR_NONE), subcolor, (subcolor != ZCGI_COLOR_NONE));
}
