/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zcgi.h"

void zcgiWriteCheckboxHeader( struct zcgidata_t *cd, const char *header, zint_t color, Boolean spec)
{
  zcgiWritef( cd, "%{"
      "%~s%[<font color=\"" ZCGI_COLOR_PRINT_FORMAT "\">%]%t%[</font>%]%~s",
    spec ? "<fieldset>\n<legend><b>" : "<dl>\n<dt><b>",
    (color != ZCGI_COLOR_NONE), color, header, (color != ZCGI_COLOR_NONE),
    spec ? "</b></legend>\n" : "</b></dt>\n");
}

void zcgiWriteCheckboxEnd( struct zcgidata_t *cd, Boolean spec)
{
  zcgiWritef( cd, "%~s", spec ? "</fieldset>\n" : "</dl>\n");
}
