/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcgi.h"

struct color_t
{
  const char *name;
  zint_t value;
};

static struct color_t colorTable[] =
{
  { "antiquewhite",      __ZINT(0xfaebd7) },
  { "aqua",              __ZINT(0x00ffff) },
  { "aquamarine",        __ZINT(0x7fffd4) },
  { "azure",             __ZINT(0xf0ffff) },
  { "beige",             __ZINT(0xf5f5dc) },
  { "bisque",            __ZINT(0xffe4c4) },
  { "black",             __ZINT(0x000000) },
  { "blanchedalmond",    __ZINT(0xffebcd) },
  { "blue",              __ZINT(0x0000ff) },
  { "blueviolet",        __ZINT(0x8a2be2) },
  { "brown",             __ZINT(0xa52a2a) },
  { "burlywood",         __ZINT(0xdeb887) },
  { "cadetblue",         __ZINT(0x5f9ea0) },
  { "chartreuse",        __ZINT(0x7fff00) },
  { "chocolate",         __ZINT(0xd2691e) },
  { "coral",             __ZINT(0xff7f50) },
  { "cornflowerblue",    __ZINT(0x6495ed) },
  { "cornsilk",          __ZINT(0xfff8dc) },
  { "crimson",           __ZINT(0xdc143c) },
  { "cyan",              __ZINT(0x00ffff) },
  { "darkblue",          __ZINT(0x00008b) },
  { "darkcyan",          __ZINT(0x008b8b) },
  { "darkgoldenrod",     __ZINT(0xb8860b) },
  { "darkgray",          __ZINT(0xa9a9a9) },
  { "darkgreen",         __ZINT(0x006400) },
  { "darkkhaki",         __ZINT(0xbdb76b) },
  { "darkmagenta",       __ZINT(0x8b008b) },
  { "darkolivegreen",    __ZINT(0x556b2f) },
  { "darkorange",        __ZINT(0xff8c00) },
  { "darkorchid",        __ZINT(0x9932cc) },
  { "darkred",           __ZINT(0x8b0000) },
  { "darksalmon",        __ZINT(0xe9967a) },
  { "darkseagreen",      __ZINT(0x8fbc8f) },
  { "darkslateblue",     __ZINT(0x483d8b) },
  { "darkslategray",     __ZINT(0x2f4f4f) },
  { "darkturquoise",     __ZINT(0x00ced1) },
  { "darkviolet",        __ZINT(0x9400d3) },
  { "deeppink",          __ZINT(0xff1493) },
  { "deepskyblue",       __ZINT(0x00bfff) },
  { "dimgray",           __ZINT(0x696969) },
  { "dodgerblue",        __ZINT(0x1e90ff) },
  { "firebrick",         __ZINT(0xb22222) },
  { "floralwhite",       __ZINT(0xfffaf0) },
  { "forestgreen",       __ZINT(0x228b22) },
  { "fuchsia",           __ZINT(0xff00ff) },
  { "gainsboro",         __ZINT(0xdcdcdc) },
  { "ghostwhite",        __ZINT(0xf8f8ff) },
  { "gold",              __ZINT(0xffd700) },
  { "goldenrod",         __ZINT(0xdaa520) },
  { "gray",              __ZINT(0x808080) },
  { "green",             __ZINT(0x008000) },
  { "greenyellow",       __ZINT(0xadff2f) },
  { "honeydew",          __ZINT(0xf0fff0) },
  { "hotpink",           __ZINT(0xff69b4) },
  { "indianred",         __ZINT(0xcd5c5c) },
  { "indigo",            __ZINT(0x4b0082) },
  { "ivory",             __ZINT(0xfffff0) },
  { "khaki",             __ZINT(0xf0e68c) },
  { "lavender",          __ZINT(0xe6e6fa) },
  { "lavenderblush",     __ZINT(0xfff0f5) },
  { "lawngreen",         __ZINT(0x7cfc00) },
  { "lemonchiffon",      __ZINT(0xfffacd) },
  { "lightblue",         __ZINT(0xadd8e6) },
  { "lightcoral",        __ZINT(0xf08080) },
  { "lightcyan",         __ZINT(0xe0ffff) },
  { "lightgoldenrodyel", __ZINT(0x0000de) },
  { "lightgreen",        __ZINT(0x90ee90) },
  { "lightgrey",         __ZINT(0xd3d3d3) },
  { "lightpink",         __ZINT(0xffb6c1) },
  { "lightsalmon",       __ZINT(0xffa07a) },
  { "lightseagreen",     __ZINT(0x20b2aa) },
  { "lightskyblue",      __ZINT(0x87cefa) },
  { "lightslategray",    __ZINT(0x778899) },
  { "lightsteelblue",    __ZINT(0xb0c4de) },
  { "lightyellow",       __ZINT(0xffffe0) },
  { "lime",              __ZINT(0x00ff00) },
  { "limegreen",         __ZINT(0x32cd32) },
  { "linen",             __ZINT(0xfaf0e6) },
  { "magenta",           __ZINT(0xff00ff) },
  { "maroon",            __ZINT(0x800000) },
  { "mediumaquamarine",  __ZINT(0x66cdaa) },
  { "mediumblue",        __ZINT(0x0000cd) },
  { "mediumorchid",      __ZINT(0xba55d3) },
  { "mediumpurple",      __ZINT(0x9370db) },
  { "mediumseagreen",    __ZINT(0x3cb371) },
  { "mediumslateblue",   __ZINT(0x7b68ee) },
  { "mediumspringgreen", __ZINT(0x00fa9a) },
  { "mediumturquoise",   __ZINT(0x48d1cc) },
  { "mediumvioletred",   __ZINT(0xc71585) },
  { "midnightblue",      __ZINT(0x191970) },
  { "mintcream",         __ZINT(0xf5fffa) },
  { "mistyrose",         __ZINT(0xffe4e1) },
  { "moccasin",          __ZINT(0xffe4b5) },
  { "navajowhite",       __ZINT(0xffdead) },
  { "navy",              __ZINT(0x000080) },
  { "none",              ZCGI_COLOR_NONE  },
  { "oldlace",           __ZINT(0xfdf5e6) },
  { "olive",             __ZINT(0x808000) },
  { "olivedrab",         __ZINT(0x6b8e23) },
  { "orange",            __ZINT(0xffa500) },
  { "orangered",         __ZINT(0xff4500) },
  { "orchid",            __ZINT(0xda70d6) },
  { "palegoldenrod",     __ZINT(0xeee8aa) },
  { "palegreen",         __ZINT(0x98fb98) },
  { "paleturquoise",     __ZINT(0xafeeee) },
  { "palevioletred",     __ZINT(0xdb7093) },
  { "papayawhip",        __ZINT(0xffefd5) },
  { "peachpuff",         __ZINT(0xffdab9) },
  { "peru",              __ZINT(0xcd853f) },
  { "pink",              __ZINT(0xffc0db) },
  { "plum",              __ZINT(0xdda0dd) },
  { "powderblue",        __ZINT(0xb0e0e6) },
  { "purple",            __ZINT(0x800080) },
  { "red",               __ZINT(0xff0000) },
  { "rosybrown",         __ZINT(0xbc8f8f) },
  { "royalblue",         __ZINT(0x4169e1) },
  { "saddlebrown",       __ZINT(0x8b4513) },
  { "salmon",            __ZINT(0xfa8072) },
  { "sandybrown",        __ZINT(0xf4a460) },
  { "seagreen",          __ZINT(0x2e8b57) },
  { "seashell",          __ZINT(0xfff5ee) },
  { "sienna",            __ZINT(0xa0522d) },
  { "silver",            __ZINT(0xc0c0c0) },
  { "skyblue",           __ZINT(0x87ceeb) },
  { "slateblue",         __ZINT(0x6a5acd) },
  { "slategray",         __ZINT(0x708090) },
  { "snow",              __ZINT(0xfffafa) },
  { "springgreen",       __ZINT(0x00ff7f) },
  { "steelblue",         __ZINT(0x4682b4) },
  { "tan",               __ZINT(0xd2b48c) },
  { "teal",              __ZINT(0x008080) },
  { "thistle",           __ZINT(0xd8bfd8) },
  { "tomato",            __ZINT(0xdd6347) },
  { "turquoise",         __ZINT(0x40e0d0) },
  { "violet",            __ZINT(0xee82ee) },
  { "wheat",             __ZINT(0xf5deb3) },
  { "white",             __ZINT(0xffffff) },
  { "whitesmoke",        __ZINT(0xf5f5f5) },
  { "yellow",            __ZINT(0xffff00) },
  { "yellowgreen",       __ZINT(0x9acd32) },
  { NULL,                ZCGI_COLOR_NONE  }
};

#define COLOR_COUNT      (sizeof( colorTable ) / sizeof( struct color_t ) - 1)

zint_t zcgiColorNumber( const char *name )
{
  int lower, upper;

  for( lower=0, upper=COLOR_COUNT-1; lower <= upper; )
  {
    register int midpoint = (lower + upper) >> 1;
    register int cmp = strcasecmp( name, colorTable[midpoint].name);

    if( cmp == 0 ) return colorTable[midpoint].value;

    if( cmp > 0 )
      lower = midpoint + 1;
    else
      upper = midpoint - 1;
  }

  return ZCGI_COLOR_NONE;
}
