/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"

#include "zcontext.h"
#include "zerror.h"
#include "zstdio.h"
#include "zcgi.h"

void zcgiWriteError( struct zcgidata_t *cd )
{
  const char *error;
  char buf[256];

  switch( _zErrorCode( cd->context->errorCode ) )
  {
    case zecNone:
      return;
    case zecNoMemory:
      error = "No free memory";
      break;
    case zecInvalidValue:
      error = "Error of parsing the CGI input";
      break;
    case zecFileRead:
      error = "Cann't read the CGI input from stdin";
      break;
    case zecFileWrite:
      error = "Cann't write the data to stdout";
      break;
    default:
      zsprintf( buf, sizeof( buf ), "Unknown error #%d", _zErrorCode( cd->context->errorCode ));
      error = buf;
  }

  zcgiStartDocument( cd, "General CGI failure");
  zcgiWritef( cd, "%{<h1 align=\"center\">CGI error</h1>\n<p>%t</p>\n", error);
  zcgiEndDocument( cd );
}
