/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zstdio.h"
#include "zcgi.h"

#define DOCUMENT_START_LINE "Content-type: text/html\n\n" \
                            "<!DOCTYPE HTML public \"-//W3O//DTD W3 HTML 4.0//EN\">\n" \
                            "<html>\n"
#define DOCUMENT_END_LINE   "</body>\n</html>\n"
#define HEAD_START_LINE     "<head>\n"
#define HEAD_END_LINE       "</head>\n"

void zcgiStartDocument( struct zcgidata_t *cd, const char *title)
{
  if( zCheckFlags( cd->flags, ZCGI_FLAG_START_DOCUMENT) ) return;
  zSetFlags( cd->flags, ZCGI_FLAG_START_DOCUMENT);

  zcgiWriteData( cd, zpfDontRecode, DOCUMENT_START_LINE, sizeof(DOCUMENT_START_LINE)-1);
  if( title != NULL || cd->headAddition != NULL )
  {
    zcgiWriteData( cd, zpfDontRecode, HEAD_START_LINE, sizeof(HEAD_START_LINE)-1);
    if( title != NULL )
      zcgiWritef( cd, "%{<title>%t</title>\n", title);
    if( cd->headAddition != NULL ) cd->headAddition( cd );
    zcgiWriteData( cd, zpfDontRecode, HEAD_END_LINE, sizeof(HEAD_END_LINE)-1);
  }

  zcgiWritef( cd, "<body");
  if( cd->pageBackgroundImage != NULL ) zcgiWritef( cd, "%{ background=\"%s\"", cd->pageBackgroundImage);
  if( cd->pageBackgroundColor != ZCGI_COLOR_NONE ) zcgiWritef( cd, "%{ bgcolor=\"" ZCGI_COLOR_PRINT_FORMAT "\"", cd->pageBackgroundColor);
  if( cd->pageTextColor != ZCGI_COLOR_NONE ) zcgiWritef( cd, "%{ text=\"" ZCGI_COLOR_PRINT_FORMAT "\"", cd->pageTextColor);
  if( cd->pageLinkColor != ZCGI_COLOR_NONE ) zcgiWritef( cd, "%{ link=\"" ZCGI_COLOR_PRINT_FORMAT "\"", cd->pageLinkColor);
  if( cd->pageVLinkColor != ZCGI_COLOR_NONE ) zcgiWritef( cd, "%{ vlink=\"" ZCGI_COLOR_PRINT_FORMAT "\"", cd->pageVLinkColor);
  if( cd->pageALinkColor != ZCGI_COLOR_NONE ) zcgiWritef( cd, "%{ alink=\"" ZCGI_COLOR_PRINT_FORMAT "\"", cd->pageALinkColor);
  if( cd->bodyTagAddition != NULL ) zcgiWritef( cd, " %s", cd->bodyTagAddition);
  zcgiWritef( cd, ">\n");

  zcgiWriteData( cd, zpfFlush, NULL, 0);
}

void zcgiEndDocument( struct zcgidata_t *cd )
{
  if( zCheckFlags( cd->flags, ZCGI_FLAG_END_DOCUMENT) ) return;
  zSetFlags( cd->flags, ZCGI_FLAG_END_DOCUMENT);
  zcgiWriteData( cd, zpfDontRecode, DOCUMENT_END_LINE, sizeof(DOCUMENT_END_LINE)-1);
}
