/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zerror.h"
#include "zcgi.h"

Boolean zcgiWriteFile( struct zcgidata_t *cd, const char *fileName, const char *fileAlias)
{
  char buf[1024];
  Boolean success = True;
  FILE *stream;

  if( (stream = fopen( fileName, READ_T_MODE)) == NULL )
  {
    cd->context->errorCode = zerFileOpen;
    cd->context->errorPtr = (fileAlias == NULL) ? fileName : fileAlias;
    return False;
  }

  while( fgets( buf, sizeof( buf ), stream) != NULL )
    zcgiWritef( cd, "%s", buf);

  if( ferror( stream ) )
  {
    cd->context->errorCode = zerFileRead;
    cd->context->errorPtr = (fileAlias == NULL) ? fileName : fileAlias;
    clearerr( stream );
    success = False;
  }

  fclose( stream );

  return success;
}

int zcgiWriteFileBlock( struct zcgidata_t *cd, const char *fileName, 
    const char *fileAlias, const char *blockName)
{
  Boolean isActive = False;
  FILE *stream;
  char line[1024];
  int length = strlen( blockName );
  int retval = 1;

  if( (stream = fopen( fileName, READ_T_MODE)) == NULL )
  {
    cd->context->errorCode = zerFileOpen;
    cd->context->errorPtr = (fileAlias == NULL) ? fileName : fileAlias;
    return False;
  }

  while( fgets( line, sizeof( line ), stream) != NULL )
    if( *line == '[' )
    {
      if( isActive ) break;
      if( strncasecmp( &line[1], blockName, length) == 0 && line[1+length] == ']' )
      {
        isActive = True;
        retval = 0;
      }
    }
    else if( isActive )
      zcgiWritef( cd, "%t", line);

  if( ferror( stream ) )
  {
    cd->context->errorCode = zerFileRead;
    cd->context->errorPtr = (fileAlias == NULL) ? fileName : fileAlias;
    clearerr( stream );
    retval = -1;
  }

  fclose( stream );

  return retval;
}
