/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include <stdarg.h>

#include "zstdio.h"
#include "zcgi.h"

Boolean zcgiWriteData( struct zcgidata_t *cd, unsigned int flags, const char *data, int length)
{
  return zPrintData( cd->context, flags, data, length);
}

Boolean zcgiWritef( struct zcgidata_t *cd, const char *fmt, ...)
{
  Boolean success;
  va_list args;

  va_start( args, fmt);
  success = zvprintf( cd->context, fmt, args);
  va_end( args );

  return success;
}
