/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zcharset.h"
#include "zurl.h"
#include "zcgi.h"

#ifdef RUSSIAN_SUPPORT
void zcgiCharsetSetup( struct zcgidata_t *cd, Boolean full)
{
  struct zcontext_t *cnt = cd->context;
  struct zcginput_t *id;
  int remoteCharset, remoteStrictCharset;

  remoteCharset = remoteStrictCharset = ZCHARSET_UNKNOWN;

/*      ࢠ  Russian Appache.  ⠪
  砥  ⠢  㤠 ஢ -   뤠 ⮣
  ⥪ ( ஢ Web-ࢥ;  㤥 ⥬ ॢ ࢥ஬ 
   ஢),  -  ࠭஢ ⥪
  (%xx  URL', &#nnn;  ..;  ⥪ 㦥   ᬮ 
  ४஢ ࢥ஬, ⮬   ⤠ ࠧ  ஢
  ). */
  if( cd->env[ZCGI_ENV_LOCAL_CHARSET] != NULL &&
      cd->env[ZCGI_ENV_REMOTE_CHARSET] != NULL )
  {
    remoteCharset = zCharsetType( cd->env[ZCGI_ENV_LOCAL_CHARSET] );
    remoteStrictCharset = zCharsetType( cd->env[ZCGI_ENV_REMOTE_CHARSET] );
    zSetFlags( cd->flags, ZCGI_FLAG_RUSSIAN_APACHE);
  }
  else if( full )
  {
    /* ।塞 ஢ .  ⢨:
        * ᭠砫 ᬮਬ 祭  ࠬ 'cs'  CGI ;
        * ⥬ ⠥ । ஢  ஡ ᫮;
        * ⥬ ஡㥬 ६ 㦥 "CHARSET".
       ᫨    ,  ⠥,  ஢  ᮢ
        쭮. */
    if( (id = zcgiFindInput( cd, ZCGI_PARAM_CHARSET, NULL)) != NULL && id->valueLength > 0 )
      remoteCharset = zCharsetType( id->value );
    if( remoteCharset == ZCHARSET_UNKNOWN &&
        (id = zcgiFindInput( cd, ZCGI_PARAM_CSWORD, NULL)) != NULL && id->valueLength > 0 )
      remoteCharset = zCharsetByWord( id->value, ZCGI_DEFAULT_CSWORD, cnt->localCharset);
    if( remoteCharset == ZCHARSET_UNKNOWN && cd->env[ZCGI_ENV_REMOTE_CHARSET] != NULL )
      remoteCharset = zCharsetType( cd->env[ZCGI_ENV_REMOTE_CHARSET] );
  }

  if( remoteCharset == ZCHARSET_UNKNOWN )
  {
    zSetFlags( cd->flags, ZCGI_FLAG_DEFAULT_CHARSET);
    remoteCharset = cnt->localCharset;
  }

/* ⠭ ⠡ ४஢ */
  (void) zSetRemoteCharset( cnt, ZCHARSET_UNKNOWN, remoteCharset);
  if( zCharsetValid( remoteStrictCharset ) )
    (void) zSetRemoteStrictCharset( cnt, remoteStrictCharset);
  zSetFlags( cd->flags, ZCGI_FLAG_CHARSET);
}

void zcgiUnsetStrictRecoding( struct zcgidata_t *cd )
{
  zUnsetFlags( cd->context->ioFlags, ZCONTEXT_IOFLAG_STRICT_VALUE);
  zUnsetFlags( cd->urlFlags, zufStrict);
  (void) zSetRemoteStrictCharset( cd->context, cd->context->remoteCharset);
}

const char *zcgiRemoteCharsetName( struct zcgidata_t *cd )
{
  if( cd->context->remoteCharset == ZCHARSET_UNKNOWN ) return NULL;
  return zCharsetName( cd->context->remoteCharset, ZCHARSET_NAME_OFFICIAL);
}

const char *zcgiRemoteStrictCharsetName( struct zcgidata_t *cd )
{
  if( cd->context->remoteStrictCharset == ZCHARSET_UNKNOWN ) return NULL;
  return zCharsetName( cd->context->remoteStrictCharset, ZCHARSET_NAME_OFFICIAL);
}

void zcgiRecodeInput( struct zcgidata_t *cd )
{
  if( zCheckFlags( cd->flags, ZCGI_FLAG_RECODE) ) return;
  if( !zCheckFlags( cd->flags, ZCGI_FLAG_CHARSET) ) zcgiCharsetSetup( cd, True);

  if( zCheckFlags( cd->context->ioFlags, ZCONTEXT_IOFLAG_CHARSET_CONV) )
  {
    char *table = cd->context->convTable;
    int i;

    for( i = 0; i < cd->inputCount; i++)
    {
      struct zcginput_t *ci = &cd->inputList[i];
      zRecode8( ci->name, table);
      zRecode8( ci->value, table);
    }
  }

  zSetFlags( cd->flags, ZCGI_FLAG_RECODE);
}
#endif
