/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#include <stdlib.h>

#include "zchars.h"
#include "zcgi.h"

void zcgiGetUserAgent( struct zcgidata_t *cd )
{
  const char *userAgent, *s, *ptr;

  if( zCheckFlags( cd->flags, ZCGI_FLAG_USER_AGENT) ) return;
  zSetFlags( cd->flags, ZCGI_FLAG_USER_AGENT);

  cd->userAgentType = agtUnknown;
  cd->userAgentVersion = 0;

  zcgiGetEnvironment( cd );
  if( (userAgent = cd->env[ZCGI_ENV_HTTP_USER_AGENT]) == NULL ) return;

  if( strncasecmp( userAgent, "Mozilla", 7) == 0 )
  {
    s = userAgent + 7;
    if( strstr( s, "compatible") != NULL )
    {
      if( (ptr = strstr( s, "MSIE")) == NULL )
        cd->userAgentType = agtMozillaCompatible;
      else
      {
        cd->userAgentType = agtExplorer;
        s = ptr + 4;
      }
    }
    else
      cd->userAgentType = agtNavigator;
  }
  else if( strncasecmp( userAgent, "Lynx", 4) == 0 )
  {
    cd->userAgentType = agtLynx;
    s = userAgent + 4;
  }
  else if( strncasecmp( userAgent, "DosLynx", 7) == 0 )
  {
    cd->userAgentType = agtDosLynx;
    s = userAgent + 7;
  }
  else
    return;

  if( (*s == '/' || *s == ' ') && isDigit( s[1] ) )
  {
    cd->userAgentVersion = (int) strtol( ++s, (char **) &s, 10) * 100;
    if( *s == '.' && isDigit( s[1] ) )
      if( !isDigit( s[2] ) )
        cd->userAgentVersion += (int) strtol( ++s, NULL, 10) * 10;
      else if ( !isDigit( s[3] ) )
        cd->userAgentVersion += (int) strtol( s, NULL, 10);
  }
}
