/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zstdlib.h"

#include "zcgi.h"

/***************************************************************************/
/*                                                                         */
/*  Request method                                                         */
/*                                                                         */
/***************************************************************************/

static const struct zstatus_t rmethodTable[] =
{
  { "get",  ZCGI_RMETHOD_GET     },
  { "post", ZCGI_RMETHOD_POST    },
  { NULL,   ZCGI_RMETHOD_UNKNOWN }
};

int zcgiGetRequestMethodByName( const char *requestMethod )
{
  if( requestMethod == NULL || requestMethod == '\0' ) return ZCGI_RMETHOD_UNKNOWN;
  return (int) zGetStatusByName( rmethodTable, requestMethod);
}

const char *zcgiGetRequestMethodByType( int type )
{
  switch( type )
  {
    case ZCGI_RMETHOD_GET:
    case ZCGI_RMETHOD_POST:
      return rmethodTable[type-1].name;
    default:
      return NULL;
  }
}
