/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#include <stdlib.h>

#include "zchars.h"

#include "zcgi.h"

/***************************************************************************/
/*                                                                         */
/*  CGI Environment                                                        */
/*                                                                         */
/***************************************************************************/

struct zcgienv_t
{
  const char *name;
  char number;
};

static const struct zcgienv_t envTable[] =
{
  { "QUERY_STRING",                     ZCGI_ENV_QUERY_STRING      },
  { "REQUEST_METHOD",                   ZCGI_ENV_REQUEST_METHOD    },
  { "CONTENT_LENGTH",                   ZCGI_ENV_CONTENT_LENGTH    },
#ifdef RUSSIAN_SUPPORT
#ifdef HTTPD_LOCAL_CHARSET_ENVIRONMENT
  { HTTPD_LOCAL_CHARSET_ENVIRONMENT,    ZCGI_ENV_LOCAL_CHARSET     },
#endif
#ifdef HTTPD_REMOTE_CHARSET_ENVIRONMENT
  { HTTPD_REMOTE_CHARSET_ENVIRONMENT,   ZCGI_ENV_REMOTE_CHARSET    },
#endif
#endif
#ifdef _ZCGI_AUTH_TYPE
  { "AUTH_TYPE",                        ZCGI_ENV_AUTH_TYPE         },
#endif
#ifdef _ZCGI_CONTENT_TYPE
  { "CONTENT_TYPE",                     ZCGI_ENV_CONTENT_TYPE      },
#endif
#ifdef _ZCGI_GATEWAY_INTERFACE
  { "GATEWAY_INTERFACE",                ZCGI_ENV_GATEWAY_INTERFACE },
#endif
#ifdef _ZCGI_HTTP_ACCEPT
  { "HTTP_ACCEPT",                      ZCGI_ENV_HTTP_ACCEPT       },
#endif
#ifdef _ZCGI_HTTP_REFERER
  { "HTTP_REFERER",                     ZCGI_ENV_HTTP_REFERER      },
#endif
#ifdef _ZCGI_HTTP_USER_AGENT
  { "HTTP_USER_AGENT",                  ZCGI_ENV_HTTP_USER_AGENT   },
#endif
#ifdef _ZCGI_PATH_INFO
  { "PATH_INFO",                        ZCGI_ENV_PATH_INFO         },
#endif
#ifdef _ZCGI_PATH_TRANSLATED
  { "PATH_TRANSLATED",                  ZCGI_ENV_PATH_TRANSLATED   },
#endif
#ifdef _ZCGI_REMOTE_ADDR
  { "REMOTE_ADDR",                      ZCGI_ENV_REMOTE_ADDR       },
#endif
#ifdef _ZCGI_REMOTE_HOST
  { "REMOTE_HOST",                      ZCGI_ENV_REMOTE_HOST       },
#endif
#ifdef _ZCGI_REMOTE_IDENT
  { "REMOTE_IDENT",                     ZCGI_ENV_REMOTE_IDENT      },
#endif
#ifdef _ZCGI_REMOTE_USER
  { "REMOTE_USER",                      ZCGI_ENV_REMOTE_USER       },
#endif
#ifdef _ZCGI_SCRIPT_FILENAME
  { "SCRIPT_FILENAME",                  ZCGI_ENV_SCRIPT_FILENAME   },
#endif
#ifdef _ZCGI_SCRIPT_NAME
  { "SCRIPT_NAME",                      ZCGI_ENV_SCRIPT_NAME       },
#endif
#ifdef _ZCGI_SERVER_NAME
  { "SERVER_NAME",                      ZCGI_ENV_SERVER_NAME       },
#endif
#ifdef _ZCGI_SERVER_PORT
  { "SERVER_PORT",                      ZCGI_ENV_SERVER_PORT       },
#endif
#ifdef _ZCGI_SERVER_PROTOCOL
  { "SERVER_PROTOCOL",                  ZCGI_ENV_SERVER_PROTOCOL   },
#endif
#ifdef _ZCGI_SERVER_SOFTWARE
  { "SERVER_SOFTWARE",                  ZCGI_ENV_SERVER_SOFTWARE   },
#endif
  { NULL }
};

void zcgiGetEnvironment( struct zcgidata_t *cd )
{
  const struct zcgienv_t *env;
  char *s;

  if( zCheckFlags( cd->flags, ZCGI_FLAG_ENV) ) return;

  for( env = envTable; env->name != NULL; env++)
    if( (s = getenv( env->name )) != NULL )
    {
      while( isSpace( *s ) ) s++;
      cd->env[env->number] = s;
    }

  zSetFlags( cd->flags, ZCGI_FLAG_ENV);
}

const char *zcgiGetenv( struct zcgidata_t *cd, const char *name)
{
  int i;

  for( i = 0; envTable[i].name != NULL; i++)
    if( strcmp( name, envTable[i].name) == 0 ) return cd->env[i];

  return getenv( name );
}
