/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zalloc.h"
#include "zstdio.h"
#include "zurl.h"
#include "zcgi.h"

void zcgiInitData( struct zcontext_t *cnt, struct zcgidata_t *cd)
{
  ZEROFILL( cd, sizeof( struct zcgidata_t ));
  cd->context = cnt;
  cnt->cgiData = cd;

  cnt->input = stdin;
  zioSetOutputStream( cnt, stdout, NULL);
  zSetFlags( cd->urlFlags, zufStrict);

  cd->pageBackgroundColor = cd->pageTextColor = cd->pageLinkColor =
    cd->pageVLinkColor = cd->pageALinkColor = ZCGI_COLOR_NONE;
}

void zcgiFreeData( struct zcgidata_t *cd )
{
  _ZFREE( cd->context, cd->getInputString);
  _ZFREE( cd->context, cd->postInputString);
  _ZFREE( cd->context, cd->inputList);
}
