/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZTYPES_A
#define __ZTYPES_A

#ifndef __ZDEFS_A
#error Should be included through "zdefs.h"
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef enum{ False = 0, True = 1 } Boolean;

/* zint_t, zshort_t & zoff_t */
#if SIZEOF_INT == 4
# define zint_t        int
# define __ZINT(x)     x
# define _ZINT_FORMAT  ""
# define SIZEOF_ZINT   4
#elif SIZEOF_SHORT == 4
# define zint_t        short
# define __ZINT(x)     x
# define _ZINT_FORMAT  ""
# define SIZEOF_ZINT   4
#elif SIZEOF_LONG == 4
# define __ZINT(x)     x##L
# define zint_t        long
# define _ZINT_FORMAT  "l"
# define SIZEOF_ZINT   4
#elif SIZEOF_INT > 4
# define zint_t        int
# define __ZINT(x)     x
# define _ZINT_FORMAT  ""
# define SIZEOF_ZINT   8
#else
# error Unable to define four bytes interger variable
#endif

# define zlong_t       long

#if SIZEOF_LONG == 2
# define zshort_t      short
# define SIZEOF_ZSHORT 2
#elif SIZEOF_INT == 2
# define zshort_t      int
# define SIZEOF_ZSHORT 2
#elif SIZEOF_SHORT > 2
# define zshort_t      short
# define SIZEOF_ZSHORT 4
#elif SIZEOF_INT > 2
# define zshort_t      int
# define SIZEOF_ZSHORT 4
#else
# error Unable to define two bytes interger variable
#endif

#if SIZEOF_LONG == 4
# define zoff_t        long
# define _ZOFF_FORMAT  "l"
#else
# define zoff_t        zint_t
# define _ZOFF_FORMAT  _ZINT_FORMAT
#endif

/* Export/import */
/* ZEXT => _ZEXPORTV/_ZIMPORTV -  ६  .h 䠩 */
/* ZDEF => _ZEXPORTD/_ZIMPORTD - export ६  .c 䠩 */
/* ZAPI => _ZEXPORTP/_ZEXPORTP -  㭪樨  .h 䠩 */
/* ZFUN => _ZEXPORTF/_ZEXPORTF - export 㭪樨  .c 䠩 */

#if defined( _ZAPI )
#  if defined( _ZEXPORT )
#    if defined( __ZEXPORTD )
#      define ZDEF(type) __ZEXPORTD(type)
#    endif
#    if defined( __ZEXPORTV )
#      define ZEXT(type) __ZEXPORTV(type)
#    endif
#    if defined( __ZEXPORTP )
#      define ZAPI(type) __ZEXPORTP(type)
#    endif
#    if defined( __ZEXPORTF )
#      define ZFUN(type) __ZEXPORTF(type)
#    endif
#  else
#    if defined( __ZIMPORTD )
#      define ZDEF(type) __ZIMPORTD(type)
#    endif
#    if defined( __ZIMPORTV )
#      define ZEXT(type) __ZIMPORTV(type)
#    endif
#    if defined( __ZIMPORTP )
#      define ZAPI(type) __ZIMPORTP(type)
#    endif
#    if defined( __ZIMPORTF )
#      define ZFUN(type) __ZIMPORTF(type)
#    endif
#  endif
#endif

#if !defined( ZDEF )
#define ZDEF(type) type
#endif
#if !defined( ZEXT )
#define ZEXT(type) extern type
#endif
#if !defined( ZAPI )
#define ZAPI(type) type
#endif
#if !defined( ZFUN )
#define ZFUN(type) type
#endif

/* */
#if defined( __MSDOS__ ) || defined( __WIN32__ ) || defined( __OS2__ )
#define READ_B_MODE          "rb"
#define READ_T_MODE          "r"
#define WRITE_B_MODE         "wb"
#define WRITE_T_MODE         "w"
#define WRITEREAD_B_MODE     "w+b"
#define WRITEREAD_T_MODE     "w+"
#define READWRITE_B_MODE     "r+b"
#define READWRITE_T_MODE     "r+"
#define APPEND_T_MODE        "a"
#define APPEND_B_MODE        "ab"
#define APPENDUPDATE_T_MODE  "a+"
#define APPENDUPDATE_B_MODE  "a+b"
#else
#define READ_B_MODE          "r"
#define READ_T_MODE          "r"
#define WRITE_B_MODE         "w"
#define WRITE_T_MODE         "w"
#define WRITEREAD_B_MODE     "w+"
#define WRITEREAD_T_MODE     "w+"
#define READWRITE_B_MODE     "r+"
#define READWRITE_T_MODE     "r+"
#define APPEND_T_MODE        "a"
#define APPEND_B_MODE        "a"
#define APPENDUPDATE_T_MODE  "a+"
#define APPENDUPDATE_B_MODE  "a+"
#endif

#if defined( __MSDOS__ ) || defined( __WIN32__ ) || defined( __OS2__ )
#define SLASH          '\\'
#define SLASH_STRING   "\\"
#else
#define SLASH          '/'
#define SLASH_STRING   "/"
#endif

/* Various structures & function types */
#ifndef __MSVC__
#pragma warn -stu
#endif

/* libz's */
struct zconfsec_t;
struct zconfdef_t;
struct zcontext_t;
struct zdatacoll_t;
struct zdataheap_t;
struct zfileobject_t;
struct zioinfo_t;
struct zparamcoll_t;
struct zprocdir_t;
struct zprocess_t;
struct zrbtree_t;
struct zreplace_t;
struct zreplacerule_t;
struct zstatus_t;
struct zstrbuf_t;
struct zstrcoll_t;
struct ztempfile_t;
struct ztimeval_t;

typedef int (*zcmp_t)( const void *, const void *);
typedef int (*zstrcmp_t)( const char *, const char *);
typedef void (*zdelete_t)( struct zcontext_t *, void *);
typedef void (*zprinterror_t)( struct zcontext_t *, unsigned zint_t, const char *);
typedef char *(*zprocessstring_t)( struct zcontext_t *, char *);
typedef void (*zmemfail_t)( struct zcontext_t *, const char *);
typedef int (*zwrite_t)( struct zcontext_t *, const char *, int);
typedef Boolean (*zflush_t)( struct zcontext_t * );

/* libzex's */
struct zcginput_t;
struct zcgidata_t;
struct zcgi_tplvalue_t;
struct zsocket_t;
struct ztelnet_t;

/* Useful macroses */
#define ZMIN(x,y)      (((x) < (y)) ? (x) : (y))
#define ZMAX(x,y)      (((x) > (y)) ? (x) : (y))

#define ZEOL(x)        ((x) == '\0' || (x) == '\n')

#define ZCOUNT(x,d)    (((x) / (d)) + (((x) % (d)) != 0 ? 1 : 0))
#define _ZALIGN(x,d)   (((x) % (d)) != 0 ? (((x) / (d) + 1) * (d)) : (x))
#define ZALIGN(x,d)    if( ((x) % (d)) != 0 ) (x) = ((x) / (d) + 1) * (d)

#define ZOFFSET(type,member) ((int) (&(((type *) 0)->member)))

#define zSetFlags(x,flags)                 ((x) |= (flags))
#define zUnsetFlags(x,flags)               ((x) &= ~(flags))
#define zUnsetFlagsEx(x,flags,t)           ((x) &= ~((t) (flags)))
#define zCheckFlags(x,flags)               ((x) & (flags))
#define zLeaveFlags(x,flags)               ((x) &= (flags))
#define zTestFlags(x,flags,value)          (((x) & (flags)) == (value))
#define zHasFlags(x,flags)                 (((x) & (flags)) == (flags))

#define ZXOR(b,p)      (((~(b)) & (p)) | ((b) & (~(p))))

#define zLowerHex(x)   (("0123456789abcdef")[(int) ((x) & 0xf)])
#define zUpperHex(x)   (("0123456789ABCDEF")[(int) ((x) & 0xf)])

#define zRecode(s,t) \
    do               \
    {                \
      register unsigned char *ptr = (unsigned char *) s, c; \
      for( ; (c = *ptr) != '\0'; ptr++) *ptr = t[ c ]; \
    } while( 0 )

#define zRecode8(s,t) \
    do                \
    {                 \
      register unsigned char *ptr = (unsigned char *) (s), c; \
      for( ; (c = *ptr) != '\0'; ptr++) \
        if( (c & 0x80) != 0 && (c = ((unsigned char *) (t))[c & 0x7f]) != '\0' ) \
          *ptr = c; \
    } while( 0 )

#define ZCLOSE(x) \
    do            \
    {             \
      if( (x) != -1 ){ close( (x) ); (x) = -1; } \
    } while( 0 )

#define ZFCLOSE(x) \
    do             \
    {              \
      if( (x) != NULL ){ fclose( (x) ); (x) = NULL; } \
    } while( 0 )

#define ZGET_ARG(x)                                     \
    if( argv[argx][2] != '\0' )                         \
      (x) = &argv[argx][2];                             \
    else if( argx == argc-1 || argv[argx+1][0] == '-' ) \
      ((x) = NULL, doUsage = True);                     \
    else                                                \
      (x) = argv[++argx]

/* Function stuff */
#if !defined( HAVE_QSORT ) || defined( QSORT_BROKEN )
void _bsd_qsort( void *a, size_t n, size_t es, zcmp_t cmp);
#define ZQSORT _bsd_qsort
#else
#define ZQSORT qsort
#endif

#ifdef __cplusplus
}
#endif

#endif
