/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZTIME_A
#define __ZTIME_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PTIME_A
#include "_ptime.h" /* <time.h> */
#endif

#if defined( HAVE_FTIME ) && !defined( HAVE_GETTIMEOFDAY )
#include <sys/timeb.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Time strings */
#define ZTIME_MONTH_JANUARY            0
#define ZTIME_MONTH_FEBRUARY           1
#define ZTIME_MONTH_MARCH              2
#define ZTIME_MONTH_APRIL              3
#define ZTIME_MONTH_MAY                4
#define ZTIME_MONTH_JUNE               5
#define ZTIME_MONTH_JULY               6
#define ZTIME_MONTH_AUGUST             7
#define ZTIME_MONTH_SEPTEMBER          8
#define ZTIME_MONTH_OCTOBER            9
#define ZTIME_MONTH_NOVEMBER           10
#define ZTIME_MONTH_DECEMBER           11

#define ZTIME_WEEKDAY_SUNDAY           0
#define ZTIME_WEEKDAY_MONDAY           1
#define ZTIME_WEEKDAY_TUESDAY          2
#define ZTIME_WEEKDAY_WEDNESDAY        3
#define ZTIME_WEEKDAY_THURSDAY         4
#define ZTIME_WEEKDAY_FRIDAY           5
#define ZTIME_WEEKDAY_SATURDAY         6

enum
{
  ztsMonthList = 0,
  ztsMonthAltList,
  ztsMonthShortList,
  ztsMonthAltShortList,
  ztsWeekdayList,
  ztsWeekdayAltList,
  ztsWeekdayShortList,
  ztsWeekdayAltShortList,
  ztsTimeFormats,
  ztsTimePeriods,
  ztsLastStrings
};

enum
{
  ztsDateFormat = 0,
  ztsDateAltFormat,
  ztsDateShortFormat,
  ztsDateAltShortFormat,
  ztsTimeFormat,
  ztsTimeAltFormat,
  ztsTimeShortFormat,
  ztsTimeAltShortFormat,
  ztsDateTimeFormat,
  ztsDateTimeAltFormat,
  ztsDateTimeShortFormat,
  ztsDateTimeAltShortFormat,
  ztsLastFormat
};

enum
{
  ztsTimePoint = 0,
  ztsTimePeriod,
  ztsStartTimePeriod,
  ztsEndTimePeriod,
  ztsLastPeriod
};

ZEXT(const char *) zMonthEnglishList[13];
ZEXT(const char *) zMonthAltEnglishList[13];
ZEXT(const char *) zMonthShortEnglishList[13];
ZEXT(const char *) zWeekdayEnglishList[8];
ZEXT(const char *) zWeekdayShortEnglishList[8];
ZEXT(const char *) zTimeEnglishFormats[ztsLastFormat+1];
ZEXT(const char *) zTimeEnglishPeriods[ztsLastPeriod+1];
ZEXT(const char **) zTimeEnglishStrings[ztsLastStrings+1];

#if defined( RUSSIAN_SUPPORT )
ZEXT(const char *) zMonthRussianList[13];
ZEXT(const char *) zMonthAltRussianList[13];
ZEXT(const char *) zMonthShortRussianList[13];
ZEXT(const char *) zWeekdayRussianList[8];
ZEXT(const char *) zWeekdayShortRussianList[8];
ZEXT(const char *) zWeekdayAltShortRussianList[8];
ZEXT(const char *) zTimeRussianFormats[ztsLastFormat+1];
ZEXT(const char *) zTimeRussianPeriods[ztsLastPeriod+1];
ZEXT(const char **) zTimeRussianStrings[ztsLastStrings+1];
#endif

#if defined( RUSSIAN_SUPPORT ) && defined( UKRAINIAN_SUPPORT )
ZEXT(const char *) zMonthUkrainianList[13];
ZEXT(const char *) zMonthAltUkrainianList[13];
ZEXT(const char *) zMonthShortUkrainianList[13];
ZEXT(const char *) zWeekdayUkrainianList[8];
ZEXT(const char *) zWeekdayShortUkrainianList[8];
ZEXT(const char *) zWeekdayAltShortUkrainianList[8];
ZEXT(const char *) zTimeUkrainianFormats[ztsLastFormat+1];
ZEXT(const char *) zTimeUkrainianPeriods[ztsLastPeriod+1];
ZEXT(const char **) zTimeUkrainianStrings[ztsLastStrings+1];
#endif

#define ZTIME_YEAR_BASE                1970
#define ZTIME_YEAR_EPOCH               1900
#define ZTIME_YEAR_MAX                 137
#define ZTIME_SECS_PER_MIN             60
#define ZTIME_MINS_PER_HOUR            60
#define ZTIME_HOUR_PER_DAY             24
#define ZTIME_SECS_PER_HOUR            (ZTIME_SECS_PER_MIN * ZTIME_MINS_PER_HOUR)
#define ZTIME_SECS_PER_DAY             (__ZINT(60) * __ZINT(60) * __ZINT(24))
#define ZTIME_DAYS_PER_WEEK            7
#define ZTIME_DAYS_PER_YEAR            365
#define ZTIME_MONT_PER_YEAR            12

ZEXT(const int) zTimeMonthDays[ZTIME_MONT_PER_YEAR+1];
ZEXT(const int) zTimeLeapDays[ZTIME_MONT_PER_YEAR+1];

#define zTimeLeapYear(y)               (((y) % 4) == 0 && (((y) % 100) != 0 || ((y) % 400) == 0))
#define zTimeLeapAddition(y)           (((y) / 4) - ((y) / 100) + ((y) / 400))
#define zTimeIsOffday(y)               (y == ZTIME_WEEKDAY_SATURDAY || y == ZTIME_WEEKDAY_SUNDAY)

time_t ztimegm( const struct tm *tm );

/* ztime_t */
typedef unsigned zint_t ztime_t;

/*
   year:   0-63 [1980-2043]
   month:  1-12
   day:    1-31
   hour:   0-23
   minute: 0-59
   second: 0-59
*/

#define ZTIME_MASK_YEAR                __ZINT(0xfc000000u)
#define ZTIME_MASK_MONTH               __ZINT(0x03c00000u)
#define ZTIME_MASK_DAY                 __ZINT(0x003e0000u)
#define ZTIME_MASK_HOUR                __ZINT(0x0001f000u)
#define ZTIME_MASK_MINUTE              __ZINT(0x00000fc0u)
#define ZTIME_MASK_SECOND              __ZINT(0x0000003fu)
#define ZTIME_MASK_DATE                __ZINT(0xfffe0000u)
#define ZTIME_MASK_TIME                __ZINT(0x0001ffffu)

#define _ZDATEV(ye,mo,da) \
    ((((((ztime_t) (da)) & 0x1f) << 1) | ((((ztime_t) (mo)) & 0x0f) << 6) | ((((ztime_t) (ye)) & 0x3f) << 10)) << 16)
#define _ZTIMEV(ho,mi,se) \
    ((((ztime_t) (se)) & 0x3f) | ((((ztime_t) (mi)) & 0x3f) << 6) | ((((ztime_t) (ho)) & 0x1f) << 12))
#define _ZTIME(ye,mo,da,ho,mi,se) \
    ((_ZDATEV((ye),(mo),(da)) & ZTIME_MASK_DATE) | (_ZTIMEV((ho),(mi),(se)) & ZTIME_MASK_TIME))

#define ZTIME_EPOCH_START              _ZTIME(0,1,1,0,0,0)
#define ZTIME_EPOCH_END                _ZTIME(0x1f,ZTIME_MONT_PER_YEAR,31,ZTIME_HOUR_PER_DAY-1,ZTIME_MINS_PER_HOUR-1,ZTIME_SECS_PER_MIN-1);

#define zTimeYear(t)                   ((int) ((((t) >> 26) & 0x3f) + 80))
#define zTimeMonth(t)                  ((int) (((t) >> 22) & 0x0f))
#define zTimeDay(t)                    ((int) (((t) >> 17) & 0x1f))
#define zTimeHour(t)                   ((int) (((t) >> 12) & 0x1f))
#define zTimeMinute(t)                 ((int) (((t) >> 6) & 0x3f))
#define zTimeSecond(t)                 ((int) ((t) & 0x3f))
#define zTimeDate(t)                   (((ztime_t) (t)) & ZTIME_MASK_DATE)
#define zTimeTime(t)                   (((ztime_t) (t)) & ZTIME_MASK_TIME)

#define ztfGlobalTime                  0x0001u
#define ztfStandardTime                0x0002u
#define ztfDaylightTime                0x0004u
#define ztfNoTime                      0x0008u
#define ztfAsIs                        0x0010u
#define ztfSunday                      0x0020u

ZAPI(ztime_t) zTime( time_t t, unsigned int flags);
ZAPI(ztime_t) zCurrentTime( unsigned int flags );
ZAPI(time_t) zNormalTime( ztime_t zt, struct tm *ptm, unsigned int flags);
ZAPI(struct tm *) zMakeTime( ztime_t zt, struct tm *ptm, unsigned int flags);
ZAPI(int) zTimeWeekday( ztime_t zt, unsigned int flags);

/* Time transform */
zint_t zTimeYearStart( ztime_t date );
zint_t zTimeYearEnd( ztime_t date );

zint_t zTimeMonthStart( ztime_t date );
zint_t zTimeMonthEnd( ztime_t date );

zint_t zTimeDayStart( ztime_t date );
zint_t zTimeDayEnd( ztime_t date );

zint_t zTimePrevMonth( zint_t date );
zint_t zTimeNextMonth( zint_t date );

zint_t zTimePrevDay( zint_t date );
zint_t zTimeNextDay( zint_t date );

ztime_t zTimePrevHour( zint_t date );
ztime_t zTimeNextHour( zint_t date );

int zTimeDayCount( ztime_t startDate, ztime_t endDate);

/* Time string */
ZAPI(int) zTimeString( char *buf, int size, const char *fmt, struct tm *tm, const char ***strings);
ZAPI(char *) zTimeFormat( char *buf, int size, const char *fmt, struct tm *tm, const char ***strings);

#define ztsDayFirst                    0x0001u
#define ztsRussianNames                0x0002u

ZAPI(ztime_t) zTimeFromString( const char *string, char **rv, unsigned int flags);

/* Time value */
#if defined( HAVE_GETTIMEOFDAY ) && defined( __MSVC__ )
struct unix_timeval
{
  long tv_sec;           /* seconds */
  long tv_usec;          /* and microseconds */
};
#endif

enum
{
  ettUnknown,
  ettTime,
  ettTimeValue
};

struct ztimeval_t
{
  int type;
#if defined( HAVE_GETTIMEOFDAY )
#if defined( __MSVC__ )
  struct unix_timeval tv;
#else
  struct timeval tv;
#endif
#elif defined( HAVE_FTIME )
  struct timeb tv;
#else
  time_t tv;
#endif
};

ZAPI(Boolean) zInitTimeValue( struct ztimeval_t *t );
ZAPI(Boolean) zSubTimeValue( struct ztimeval_t *t2, struct ztimeval_t *t1, int *psecs, int *pmsecs);
ZAPI(char *) zGetTimeValue( char *buf, int size, struct ztimeval_t *t2, struct ztimeval_t *t1);

/* Time Number */
zint_t zGetTimeNumber( zint_t delta );

#ifdef __cplusplus
}
#endif

#endif
