/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZSTRING_A
#define __ZSTRING_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

char *zNextToken( char *line, const char *terminators, char **pnext);
char *zNextWord( char *line, Boolean *wasError, char **pnext);

char *zstrcasestr( const char *string, const char *pattern);
char *zmemmem( const char *mem, int memlen, const char *pat, int patlen);
char *zmemcasemem( const char *mem, int memlen, const char *pat, int patlen);
int zstrcasecmp( const char *str1, const char *str2);
int zmemcasecmp( const char *mem1, const char *mem2, int length);

void zStringLower( char *string );
void zStringUpper( char *string );

char *zCompressString( char *string, Boolean all);
int zUnescapeString( char *string, Boolean spec);
char *zStringReplace( char *string, char what, char on);

#ifdef HAVE_CASEINDEP_FILE_NAMES
#define strsyscmp strcasecmp
#define strnsyscmp strncasecmp
#define strsysstr zstrcasestr
#else
#define strsyscmp strcmp
#define strnsyscmp strncmp
#define strsysstr strstr
#endif

#ifdef __cplusplus
}
#endif

#endif
