/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZSTDLIB_A
#define __ZSTDLIB_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* status */
struct zstatus_t
{
  const char *name;
  unsigned zint_t flag;
};

unsigned zint_t zGetStatusByName( const struct zstatus_t *table, const char *name);
const char *zGetStatusByFlag( const struct zstatus_t *table, unsigned zint_t flag);
const char *zGetStatusByValue( const struct zstatus_t *table, unsigned zint_t flag);

/* sleep */
void zsleep( unsigned int seconds );

/* bits */
unsigned zint_t rotateBits( unsigned zint_t v, int count, int bytes);

/* endian */
enum
{
  Z_UNKNOWN_ENDIAN,
  Z_LITTLE_ENDIAN,
  Z_BIG_ENDIAN
};

int zGetEndian( void );

unsigned zint_t zGetLong( const unsigned char *s, Boolean bigEndian);
unsigned zshort_t zGetShort( const unsigned char *s, Boolean bigEndian);

void zSetLong( unsigned char *s, unsigned zint_t num, Boolean bigEndian);
void zSetShort( unsigned char *s, unsigned zshort_t num, Boolean bigEndian);

/* pattern */
#define spcSingle               '?'
#define spcMultiple             '*'
#define spcSingleOpen           '['
#define spcSingleClose          ']'
#define spcMultipleOpen         '{'
#define spcMultipleClose        '}'

#define smfCaseIndep            0x0001u
#define smfBraCaseIndep         0x0002u
#define smfUseSequenceTable     0x0004u
#define smfPathSeparator        0x0008u

Boolean zIsPatternChar( int c );
Boolean zIsPatternString( const char *string );
const unsigned char *zCharMatch( unsigned int ch, const unsigned char *cstr, unsigned int flags);
Boolean zStringMatch( const char *string, const char *pattern, unsigned int flags);

Boolean zDoubleValue( const char *string, char **rest, double *value);

#ifdef __cplusplus
}
#endif

#endif
