/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZSTDIO_A
#define __ZSTDIO_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PSTDIO_A
#include "_pstdio.h"
#endif

#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

enum
{
  zioDirectionStream = 0,
  zioDirectionStrbuf,
  zioDirectionFunction
};

/*   ࠧ IO  zcontext_t */
struct zioinfo_t
{
  unsigned int ioFlags;
  unsigned int ioDirection;
  int localCharset;
  int remoteCharset;
  int remoteStrictCharset;
  char *convTable;           /* remote -> local */
  char *recodeTable;         /* local -> remote */
  char *recodeStrictTable;   /* local -> remote */
  FILE *input;
  FILE *output;
  struct zstrbuf_t *ioStrbuf;
  zwrite_t ioWrite;
  zflush_t ioFlush;
};

#define ZIO_SAVE(d,s) \
  do                  \
  {                   \
    (d)->ioFlags = (s)->ioFlags; \
    (d)->ioDirection = (s)->ioDirection; \
    (d)->localCharset = (s)->localCharset; \
    (d)->remoteCharset = (s)->remoteCharset; \
    (d)->remoteStrictCharset = (s)->remoteStrictCharset; \
    (d)->convTable = (s)->convTable; \
    (d)->recodeTable = (s)->recodeTable; \
    (d)->recodeStrictTable = (s)->recodeStrictTable; \
    (d)->input = (s)->input; \
    (d)->output = (s)->output; \
    (d)->ioStrbuf = (s)->ioStrbuf; \
    (d)->ioWrite = (s)->ioWrite; \
    (d)->ioFlush = (s)->ioFlush; \
  } while( 0 )

#define ZIO_RESTORE(d,s) ZIO_SAVE(d,s)

ZAPI(void) zioSaveInfo( struct zcontext_t *cnt, struct zioinfo_t *info);
ZAPI(void) zioRestoreInfo( struct zcontext_t *cnt, struct zioinfo_t *info);

ZAPI(void) zioSetOutputStrbuf( struct zcontext_t *cnt, struct zstrbuf_t *sb, struct zioinfo_t *info);
ZAPI(void) zioSetOutputStream( struct zcontext_t *cnt, FILE *stream, struct zioinfo_t *info);
ZAPI(void) zioSetOutputFunction( struct zcontext_t *cnt, zwrite_t writeFunc, zflush_t flushFunc, struct zioinfo_t *info);

#define zpfText                     0x0001u
#define zpfStrictText               0x0002u
#define zpfValue                    0x0004u
#define zpfStrictValue              0x0008u
#define zpfEscaped                  0x0010u
#define zpfStrictEscaped            0x0020u
#define zpfUpperCase                0x0040u
#define zpfLowerCase                0x0080u
#define zpfEscapedQuote             0x0100u
#define zpfEscapedSpace             0x0200u
#define zpfBreakLine                0x0400u
#define zpfDontRecode               0x1000u
#define zpfFlush                    0x2000u
#define zpfLast                     0x8000u

ZAPI(Boolean) zflush( struct zcontext_t *cnt );
ZAPI(Boolean) zPrintData( struct zcontext_t *cnt, unsigned int flags, const char *data, int length);

ZAPI(Boolean) zvprintf( struct zcontext_t *cnt, const char *fmt, va_list args);
ZAPI(Boolean) zprintf( struct zcontext_t *cnt, const char *fmt, ...);
ZAPI(Boolean) zfprintf( struct zcontext_t *cnt, FILE *stream, const char *fmt, ...);
ZAPI(Boolean) zsprintf( char *string, int size, const char *fmt, ...);
ZAPI(Boolean) ztprintf( struct zcontext_t *cnt, char *string, int size, const char *fmt, ...);
ZAPI(char *) zaprintf( struct zcontext_t *cnt, const char *fmt, ...);
ZAPI(char *) zbprintf( struct zcontext_t *cnt, const char *fmt, ...);

#ifdef __cplusplus
}
#endif

#endif
