/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZPROCESS_A
#define __ZPROCESS_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PSTDIO_A
#include "_pstdio.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define ZPROCESS_FLAG_WRITE_MODE       0x0001u
#define ZPROCESS_FLAG_TEXT_MODE        0x0002u
#define ZPROCESS_FLAG_BINARY_MODE      0x0004u
#define ZPROCESS_FLAG_INPUT            0x0010u
#define ZPROCESS_FLAG_OUTPUT           0x0020u
#define ZPROCESS_FLAG_ERROR            0x0040u
#define ZPROCESS_FLAG_STREAMABLE       0x0080u

#define ZPROCESS_EXITFLAG_EXITED       0x0001u
#define ZPROCESS_EXITFLAG_SIGNALED     0x0002u
#define ZPROCESS_EXITFLAG_STOPPED      0x0004u

#define ZPROCESS_MODE_UNKNOWN          0  /*     ᮧ */
#define ZPROCESS_MODE_WAIT             1  /*  襭 ஦  */
#define ZPROCESS_MODE_NOWAIT           2  /* ᨭ஭ ; 頥 pid */
#define ZPROCESS_MODE_NOWAITO          3  /* ᨭ஭ ;  ⨬  pid */
#define ZPROCESS_MODE_DETACH           4  /* ᨭ஭   㯠    ࠭ */
#define ZPROCESS_MODE_DETACH_MYSELF    5  /* ᮥ ᮡ⢥   ࠢ饣 ନ */
#define ZPROCESS_MODE_OVERLAY          6  /*   頥 ⥪騩 */
#define ZPROCESS_MODE_DONE             7  /*  㦥 訫 */

/* Pipes */
Boolean zPipeOpen( int *fds, Boolean binary);
void zPipeClose( int *fds );

/* Single sided process */
FILE *zProcessOpen( const char *commandLine, unsigned int flags);
int zProcessClose( FILE *stream );

/* Multi sized process */
struct zprocess_t
{
  unsigned int flags;
  unsigned zint_t errorCode;
  int mode;
  int osMode;
  pid_t pid;
  int exitCode;
  int signo;
  unsigned int exitFlags;
  int sin;
  int sout;
  int serr;
  int din;
  int dout;
  int derr;
  FILE *pin;
  FILE *pout;
  FILE *perr;
};

Boolean zProcessInit( struct zprocess_t *pro, int mode, unsigned int flags);
Boolean zProcessCreate( struct zprocess_t *pro, const char *exefile,
    char *argv[], char *envp[]);
Boolean zProcessWait( struct zprocess_t *pro, Boolean doWait);
void zProcessFree( struct zprocess_t *pro );

#ifdef __cplusplus
}
#endif

#endif
