/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZFILTER_A
#define __ZFILTER_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __ZFILE_A
#include "zfile.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*zprintversion_t)( struct zcontext_t *, void *);
typedef void (*zprintusage_t)( struct zcontext_t *, const char *, void *);
typedef Boolean (*zcheckusage_t)( struct zcontext_t *, struct zstrcoll_t *, void *, Boolean);
typedef Boolean (*zgetargument_t)( struct zcontext_t *, char **, int *, char **, void *);
typedef const char *(*zusageaddition_t)( struct zcontext_t *, void *);

struct zhelpers_t
{
  zprintversion_t printVersion;
  zprintusage_t printUsage;
  zcheckusage_t checkUsage;
  zgetargument_t getArgument;
  zusageaddition_t usageAddition;
};

#define zInitHelpers(h,pv,pu,cu,ga,ua) \
    do                                 \
    {                                  \
      (h)->printVersion = (pv);        \
      (h)->printUsage = (pu);          \
      (h)->checkUsage = (cu);          \
      (h)->getArgument = (ga);         \
      (h)->usageAddition = (ua);       \
    } while( 0 )

int zFilter( struct zcontext_t *cnt, int argc, char **argv,
    struct zhelpers_t *helpers, zrewritefile_t rewrite, void *info);

struct zrewritedata_t
{
  struct zcontext_t *context;
  const char *pattern;
  char *startDir;
  Boolean isstd;
  Boolean needRecursive;
  zrewritefile_t rewrite;
  void *info;
};

void zRewriteDataInit( struct zcontext_t *cnt, struct zrewritedata_t *rd,
    zrewritefile_t rewrite, void *info);
void zRewriteDataFree( struct zrewritedata_t *rd );
Boolean zRewriteDataGetInfo( struct zrewritedata_t *rd, const char *name);

#ifdef __cplusplus
}
#endif

#endif
